/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.data.game.recipe.Recipe;
import com.github.steveice10.mc.protocol.data.game.recipe.RecipeType;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapelessRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.SmithingTransformRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.StoneCuttingRecipeData;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundUpdateRecipesPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.PotionMixData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.MultiRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTrimRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemTagDescriptor;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.TrimDataPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserStonecutterData;
import org.geysermc.geyser.inventory.recipe.TrimRecipe;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ClientboundUpdateRecipesPacket.class)
public class JavaUpdateRecipesTranslator
extends PacketTranslator<ClientboundUpdateRecipesPacket> {
    private static final List<RecipeData> CARTOGRAPHY_RECIPES;
    private static final List<String> NETHERITE_UPGRADES;
    private static final Map<String, String> RECIPE_TAGS;

    /*
     * WARNING - void declaration
     */
    @Override
    public void translate(GeyserSession session, ClientboundUpdateRecipesPacket packet) {
        void var12_14;
        Map<RecipeType, List<RecipeData>> recipeTypes = Registries.CRAFTING_DATA.forVersion(session.getUpstream().getProtocolVersion());
        int netId = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        boolean sendTrimRecipes = false;
        Map<String, List<String>> recipeIDs = session.getJavaToBedrockRecipeIds();
        Int2ObjectOpenHashMap<GeyserRecipe> recipeMap = new Int2ObjectOpenHashMap<GeyserRecipe>(Registries.RECIPES.forVersion(session.getUpstream().getProtocolVersion()));
        Int2ObjectOpenHashMap<Object> unsortedStonecutterData = new Int2ObjectOpenHashMap<Object>();
        CraftingDataPacket craftingDataPacket = new CraftingDataPacket();
        craftingDataPacket.setCleanRecipes(true);
        Recipe[] recipeArray = packet.getRecipes();
        int n = recipeArray.length;
        boolean bl = false;
        while (var12_14 < n) {
            Recipe recipe = recipeArray[var12_14];
            switch (recipe.getType()) {
                case CRAFTING_SHAPELESS: {
                    ShapelessRecipeData shapelessRecipeData = (ShapelessRecipeData)recipe.getData();
                    ItemData output = ItemTranslator.translateToBedrock(session, shapelessRecipeData.getResult());
                    if (!output.isValid()) break;
                    output = output.toBuilder().tag(null).build();
                    ItemDescriptorWithCount[][] inputCombinations = this.combinations(session, shapelessRecipeData.getIngredients());
                    if (inputCombinations == null) break;
                    ArrayList<String> bedrockRecipeIDs = new ArrayList<String>();
                    for (ItemDescriptorWithCount[] itemDescriptorWithCountArray : inputCombinations) {
                        UUID uuid = UUID.randomUUID();
                        bedrockRecipeIDs.add(uuid.toString());
                        craftingDataPacket.getCraftingData().add(org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData.shapeless(uuid.toString(), Arrays.asList(itemDescriptorWithCountArray), Collections.singletonList(output), uuid, "crafting_table", 0, netId));
                        recipeMap.put(netId++, (GeyserRecipe)new GeyserShapelessRecipe(shapelessRecipeData));
                    }
                    this.addRecipeIdentifier(session, recipe.getIdentifier(), bedrockRecipeIDs);
                    break;
                }
                case CRAFTING_SHAPED: {
                    com.github.steveice10.mc.protocol.data.game.recipe.data.ShapedRecipeData shapedRecipeData = (com.github.steveice10.mc.protocol.data.game.recipe.data.ShapedRecipeData)recipe.getData();
                    ItemData output = ItemTranslator.translateToBedrock(session, shapedRecipeData.getResult());
                    if (!output.isValid()) break;
                    output = output.toBuilder().tag(null).build();
                    ItemDescriptorWithCount[][] inputCombinations = this.combinations(session, shapedRecipeData.getIngredients());
                    if (inputCombinations == null) break;
                    ArrayList<String> bedrockRecipeIDs = new ArrayList<String>();
                    for (ItemDescriptorWithCount[] itemDescriptorWithCountArray : inputCombinations) {
                        UUID uuid = UUID.randomUUID();
                        bedrockRecipeIDs.add(uuid.toString());
                        craftingDataPacket.getCraftingData().add(ShapedRecipeData.shaped(uuid.toString(), shapedRecipeData.getWidth(), shapedRecipeData.getHeight(), Arrays.asList(itemDescriptorWithCountArray), Collections.singletonList(output), uuid, "crafting_table", 0, netId));
                        recipeMap.put(netId++, (GeyserRecipe)new GeyserShapedRecipe(shapedRecipeData));
                    }
                    this.addRecipeIdentifier(session, recipe.getIdentifier(), bedrockRecipeIDs);
                    break;
                }
                case STONECUTTING: {
                    StoneCuttingRecipeData stoneCuttingData = (StoneCuttingRecipeData)recipe.getData();
                    if (stoneCuttingData.getIngredient().getOptions().length == 0) {
                        if (!GeyserImpl.getInstance().getConfig().isDebugMode()) break;
                        GeyserImpl.getInstance().getLogger().debug("Received broken stone cutter recipe: " + stoneCuttingData + " " + recipe.getIdentifier() + " " + ((Item)((List)Registries.JAVA_ITEMS.get()).get(stoneCuttingData.getResult().getId())).javaIdentifier());
                        break;
                    }
                    ItemStack ingredient = stoneCuttingData.getIngredient().getOptions()[0];
                    Object data = (List)unsortedStonecutterData.get(ingredient.getId());
                    if (data == null) {
                        data = new ArrayList();
                        unsortedStonecutterData.put(ingredient.getId(), data);
                    }
                    data.add(stoneCuttingData);
                    break;
                }
                case SMITHING_TRANSFORM: {
                    SmithingTransformRecipeData data = (SmithingTransformRecipeData)recipe.getData();
                    ItemData output = ItemTranslator.translateToBedrock(session, data.getResult());
                    for (ItemStack template : data.getTemplate().getOptions()) {
                        ItemDescriptorWithCount bedrockTemplate = ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, template));
                        for (ItemStack base : data.getBase().getOptions()) {
                            ItemDescriptorWithCount bedrockBase = ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, base));
                            for (ItemStack addition : data.getAddition().getOptions()) {
                                ItemDescriptorWithCount bedrockAddition = ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, addition));
                                String id = recipe.getIdentifier();
                                craftingDataPacket.getCraftingData().add(org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData.of(id, bedrockTemplate, bedrockBase, bedrockAddition, output, "smithing_table", netId++));
                                recipeIDs.put(id, new ArrayList<String>(Collections.singletonList(id)));
                            }
                        }
                    }
                    break;
                }
                case SMITHING_TRIM: {
                    sendTrimRecipes = true;
                    break;
                }
                case CRAFTING_DECORATED_POT: {
                    craftingDataPacket.getCraftingData().add(MultiRecipeData.of(UUID.fromString("685a742a-c42e-4a4e-88ea-5eb83fc98e5b"), netId++));
                    break;
                }
                default: {
                    List<RecipeData> craftingData = recipeTypes.get((Object)recipe.getType());
                    if (craftingData == null) break;
                    this.addSpecialRecipesIdentifiers(session, recipe, craftingData);
                    craftingDataPacket.getCraftingData().addAll(craftingData);
                }
            }
            ++var12_14;
        }
        craftingDataPacket.getCraftingData().addAll(CARTOGRAPHY_RECIPES);
        craftingDataPacket.getPotionMixData().addAll((Collection<PotionMixData>)Registries.POTION_MIXES.forVersion(session.getUpstream().getProtocolVersion()));
        Int2ObjectOpenHashMap<GeyserStonecutterData> stonecutterRecipeMap = new Int2ObjectOpenHashMap<GeyserStonecutterData>();
        for (Int2ObjectMap.Entry entry : unsortedStonecutterData.int2ObjectEntrySet()) {
            ((List)entry.getValue()).sort(Comparator.comparing(stoneCuttingRecipeData -> ((Item)((List)Registries.JAVA_ITEMS.get()).get(stoneCuttingRecipeData.getResult().getId())).javaIdentifier()));
            int buttonId = 0;
            for (StoneCuttingRecipeData stoneCuttingData : (List)entry.getValue()) {
                ItemStack ingredient = stoneCuttingData.getIngredient().getOptions()[0];
                ItemData input = ItemTranslator.translateToBedrock(session, ingredient);
                ItemDescriptorWithCount descriptor = ItemDescriptorWithCount.fromItem(input);
                ItemStack javaOutput = stoneCuttingData.getResult();
                ItemData output = ItemTranslator.translateToBedrock(session, javaOutput);
                if (!input.isValid() || !output.isValid()) continue;
                UUID uUID = UUID.randomUUID();
                craftingDataPacket.getCraftingData().add(org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData.shapeless(uUID.toString(), Collections.singletonList(descriptor), Collections.singletonList(output), uUID, "stonecutter", 0, netId));
                stonecutterRecipeMap.put(netId++, new GeyserStonecutterData(buttonId++, javaOutput));
            }
        }
        session.getLastRecipeNetId().set(netId);
        if (sendTrimRecipes) {
            TrimDataPacket trimDataPacket = new TrimDataPacket();
            trimDataPacket.getPatterns().addAll(TrimRecipe.PATTERNS);
            trimDataPacket.getMaterials().addAll(TrimRecipe.MATERIALS);
            session.sendUpstreamPacket(trimDataPacket);
            craftingDataPacket.getCraftingData().add(SmithingTrimRecipeData.of("minecraft:smithing_armor_trim", TrimRecipe.BASE, TrimRecipe.ADDITION, TrimRecipe.TEMPLATE, "smithing_table", session.getLastRecipeNetId().getAndIncrement()));
        } else {
            craftingDataPacket.getCraftingData().addAll(this.getSmithingTransformRecipes(session));
        }
        session.setOldSmithingTable(!sendTrimRecipes);
        session.sendUpstreamPacket(craftingDataPacket);
        session.setCraftingRecipes(recipeMap);
        session.setStonecutterRecipes(stonecutterRecipeMap);
        session.setJavaToBedrockRecipeIds(recipeIDs);
    }

    private void addSpecialRecipesIdentifiers(GeyserSession session, Recipe recipe, List<RecipeData> craftingData) {
        String javaRecipeID = recipe.getIdentifier();
        switch (recipe.getType()) {
            case CRAFTING_SPECIAL_BOOKCLONING: 
            case CRAFTING_SPECIAL_REPAIRITEM: 
            case CRAFTING_SPECIAL_MAPEXTENDING: 
            case CRAFTING_SPECIAL_MAPCLONING: {
                return;
            }
            case CRAFTING_SPECIAL_SHULKERBOXCOLORING: {
                javaRecipeID = "minecraft:shulker_box";
                break;
            }
            case CRAFTING_SPECIAL_TIPPEDARROW: {
                javaRecipeID = "minecraft:arrow";
            }
        }
        ArrayList<String> bedrockRecipeIDs = new ArrayList<String>();
        if (recipe.getType() == RecipeType.CRAFTING_SPECIAL_TIPPEDARROW) {
            for (RecipeData data : craftingData) {
                bedrockRecipeIDs.add(((ShapedRecipeData)data).getId());
            }
        } else {
            for (RecipeData data : craftingData) {
                bedrockRecipeIDs.add(((org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData)data).getId());
            }
        }
        this.addRecipeIdentifier(session, javaRecipeID, bedrockRecipeIDs);
    }

    private ItemDescriptorWithCount[][] combinations(GeyserSession session, Ingredient[] ingredients) {
        boolean empty = true;
        HashMap<Set, IntSet> squashedOptions = new HashMap<Set, IntSet>();
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i].getOptions().length == 0) {
                squashedOptions.computeIfAbsent(Collections.singleton(ItemDescriptorWithCount.EMPTY), k -> new IntOpenHashSet()).add(i);
                continue;
            }
            empty = false;
            Ingredient ingredient = ingredients[i];
            Map<GroupedItem, List<ItemDescriptorWithCount>> groupedByIds = Arrays.stream(ingredient.getOptions()).map(item -> ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, item))).collect(Collectors.groupingBy(item -> item == ItemDescriptorWithCount.EMPTY ? new GroupedItem(ItemDefinition.AIR, 0) : new GroupedItem(((DefaultDescriptor)item.getDescriptor()).getItemId(), item.getCount())));
            HashSet<ItemDescriptorWithCount> optionSet = new HashSet<ItemDescriptorWithCount>(groupedByIds.size());
            for (Map.Entry<GroupedItem, List<ItemDescriptorWithCount>> entry : groupedByIds.entrySet()) {
                if (entry.getValue().size() > 1) {
                    GroupedItem groupedItem = entry.getKey();
                    String recipeTag = RECIPE_TAGS.get(groupedItem.id.getIdentifier());
                    if (recipeTag != null && ingredients.length > 1) {
                        optionSet.add(new ItemDescriptorWithCount(new ItemTagDescriptor(recipeTag), groupedItem.count));
                        continue;
                    }
                    int idCount = 0;
                    for (ItemMapping mapping : session.getItemMappings().getItems()) {
                        if (mapping.getBedrockDefinition() != groupedItem.id) continue;
                        ++idCount;
                    }
                    if (entry.getValue().size() < idCount) {
                        optionSet.addAll((Collection)entry.getValue());
                        continue;
                    }
                    optionSet.add(groupedItem.id == ItemDefinition.AIR ? ItemDescriptorWithCount.EMPTY : new ItemDescriptorWithCount(new DefaultDescriptor(groupedItem.id, Short.MAX_VALUE), groupedItem.count));
                    continue;
                }
                ItemDescriptorWithCount item2 = entry.getValue().get(0);
                optionSet.add(item2);
            }
            squashedOptions.computeIfAbsent(optionSet, k -> new IntOpenHashSet()).add(i);
        }
        if (empty) {
            return null;
        }
        int totalCombinations = 1;
        for (Set optionSet : squashedOptions.keySet()) {
            totalCombinations *= optionSet.size();
        }
        if (totalCombinations > 500) {
            ItemDescriptorWithCount[] translatedItems = new ItemDescriptorWithCount[ingredients.length];
            for (int i = 0; i < ingredients.length; ++i) {
                translatedItems[i] = ingredients[i].getOptions().length > 0 ? ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, ingredients[i].getOptions()[0])) : ItemDescriptorWithCount.EMPTY;
            }
            return new ItemDescriptorWithCount[][]{translatedItems};
        }
        ArrayList sortedSets = new ArrayList(squashedOptions.keySet());
        sortedSets.sort(Comparator.comparing(Set::size, Comparator.reverseOrder()));
        ItemDescriptorWithCount[][] combinations = new ItemDescriptorWithCount[totalCombinations][ingredients.length];
        int x = 1;
        for (Set set : sortedSets) {
            IntSet slotSet = (IntSet)squashedOptions.get(set);
            int i = 0;
            for (ItemDescriptorWithCount item3 : set) {
                for (int j = 0; j < totalCombinations / set.size(); ++j) {
                    int comboIndex = i * x + j % x + j / x * set.size() * x;
                    IntIterator it = slotSet.iterator();
                    while (it.hasNext()) {
                        combinations[comboIndex][it.nextInt()] = item3;
                    }
                }
                ++i;
            }
            x *= set.size();
        }
        return combinations;
    }

    private void addRecipeIdentifier(GeyserSession session, String javaIdentifier, List<String> bedrockIdentifiers) {
        session.getJavaToBedrockRecipeIds().computeIfAbsent(javaIdentifier, k -> new ArrayList()).addAll(bedrockIdentifiers);
    }

    private List<RecipeData> getSmithingTransformRecipes(GeyserSession session) {
        ArrayList<RecipeData> recipes = new ArrayList<RecipeData>();
        ItemMapping template = session.getItemMappings().getStoredItems().upgradeTemplate();
        for (String identifier : NETHERITE_UPGRADES) {
            recipes.add(org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData.of(identifier + "_smithing", this.getDescriptorFromId(session, template.getBedrockIdentifier()), this.getDescriptorFromId(session, identifier.replace("netherite", "diamond")), this.getDescriptorFromId(session, "minecraft:netherite_ingot"), ItemData.builder().definition(Objects.requireNonNull(session.getItemMappings().getDefinition(identifier))).count(1).build(), "smithing_table", session.getLastRecipeNetId().getAndIncrement()));
        }
        return recipes;
    }

    private ItemDescriptorWithCount getDescriptorFromId(GeyserSession session, String bedrockId) {
        ItemDefinition bedrockDefinition = session.getItemMappings().getDefinition(bedrockId);
        if (bedrockDefinition != null) {
            return ItemDescriptorWithCount.fromItem(ItemData.builder().definition(bedrockDefinition).count(1).build());
        }
        GeyserImpl.getInstance().getLogger().debug("Unable to find item with identifier " + bedrockId);
        return ItemDescriptorWithCount.EMPTY;
    }

    static {
        int n = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        InventoryUtils.LAST_RECIPE_NET_ID = n;
        int n2 = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        InventoryUtils.LAST_RECIPE_NET_ID = n2;
        InventoryUtils.LAST_RECIPE_NET_ID = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        CARTOGRAPHY_RECIPES = List.of(MultiRecipeData.of(UUID.fromString("8b36268c-1829-483c-a0f1-993b7156a8f2"), n), MultiRecipeData.of(UUID.fromString("442d85ed-8272-4543-a6f1-418f90ded05d"), n2), MultiRecipeData.of(UUID.fromString("98c84b38-1085-46bd-b1ce-dd38c159e6cc"), InventoryUtils.LAST_RECIPE_NET_ID), MultiRecipeData.of(UUID.fromString("602234e4-cac1-4353-8bb7-b1ebff70024b"), ++InventoryUtils.LAST_RECIPE_NET_ID));
        NETHERITE_UPGRADES = List.of("minecraft:netherite_sword", "minecraft:netherite_shovel", "minecraft:netherite_pickaxe", "minecraft:netherite_axe", "minecraft:netherite_hoe", "minecraft:netherite_helmet", "minecraft:netherite_chestplate", "minecraft:netherite_leggings", "minecraft:netherite_boots");
        RECIPE_TAGS = Map.of("minecraft:wood", "minecraft:logs", "minecraft:wooden_slab", "minecraft:wooden_slabs", "minecraft:planks", "minecraft:planks");
    }

    private static class GroupedItem {
        ItemDefinition id;
        int count;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupedItem)) {
                return false;
            }
            GroupedItem other = (GroupedItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            ItemDefinition this$id = this.id;
            ItemDefinition other$id = other.id;
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupedItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.count;
            ItemDefinition $id = this.id;
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public GroupedItem(ItemDefinition id, int count) {
            this.id = id;
            this.count = count;
        }
    }
}

