/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;
import org.cloudburstmc.protocol.bedrock.packet.LecternUpdatePacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=LecternUpdatePacket.class)
public class BedrockLecternUpdateTranslator
extends PacketTranslator<LecternUpdatePacket> {
    @Override
    public void translate(GeyserSession session, LecternUpdatePacket packet) {
        if (packet.isDroppingBook()) {
            session.setDroppingLecternBook(true);
            ServerboundUseItemOnPacket blockPacket = new ServerboundUseItemOnPacket(packet.getBlockPosition(), Direction.DOWN, Hand.MAIN_HAND, 0.0f, 0.0f, 0.0f, false, session.getWorldCache().nextPredictionSequence());
            session.sendDownstreamGamePacket(blockPacket);
        } else {
            Inventory inventory = session.getOpenInventory();
            if (!(inventory instanceof LecternContainer)) {
                session.getGeyser().getLogger().debug("Expected lectern but it wasn't open!");
                return;
            }
            LecternContainer lecternContainer = (LecternContainer)inventory;
            if (lecternContainer.getCurrentBedrockPage() == packet.getPage()) {
                ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(lecternContainer.getJavaId());
                session.sendDownstreamGamePacket(closeWindowPacket);
                InventoryUtils.closeInventory(session, lecternContainer.getJavaId(), false);
            } else {
                int currentJavaPage;
                int newJavaPage = packet.getPage() * 2;
                if (newJavaPage > (currentJavaPage = lecternContainer.getCurrentBedrockPage() * 2)) {
                    for (int i = currentJavaPage; i < newJavaPage; ++i) {
                        ServerboundContainerButtonClickPacket clickButtonPacket = new ServerboundContainerButtonClickPacket(session.getOpenInventory().getJavaId(), 2);
                        session.sendDownstreamGamePacket(clickButtonPacket);
                    }
                } else {
                    for (int i = currentJavaPage; i > newJavaPage; --i) {
                        ServerboundContainerButtonClickPacket clickButtonPacket = new ServerboundContainerButtonClickPacket(session.getOpenInventory().getJavaId(), 1);
                        session.sendDownstreamGamePacket(clickButtonPacket);
                    }
                }
            }
        }
    }
}

