/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;

@BlockEntity(type={BlockEntityType.SKULL})
public class SkullBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        byte skullVariant = BlockStateValues.getSkullVariant(blockState);
        float rotation = (float)BlockStateValues.getSkullRotation(blockState) * 22.5f;
        if (skullVariant == -1) {
            skullVariant = 0;
        }
        builder.put("Rotation", (Object)Float.valueOf(rotation));
        builder.put("SkullType", (Object)skullVariant);
        if (BlockStateValues.isSkullPowered(blockState)) {
            builder.putBoolean("MouthMoving", true);
        }
    }

    private static UUID getUUID(CompoundTag owner) {
        IntArrayTag uuidTag;
        Object t = owner.get("Id");
        if (t instanceof IntArrayTag && (uuidTag = (IntArrayTag)t).length() == 4) {
            int[] uuidAsArray = uuidTag.getValue();
            return new UUID((long)uuidAsArray[0] << 32 | (long)uuidAsArray[1] & 0xFFFFFFFFL, (long)uuidAsArray[2] << 32 | (long)uuidAsArray[3] & 0xFFFFFFFFL);
        }
        String username = null;
        Object t2 = owner.get("Name");
        if (t2 instanceof StringTag) {
            StringTag nameTag = (StringTag)t2;
            username = nameTag.getValue().toLowerCase(Locale.ROOT);
        }
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }

    private static CompletableFuture<String> getTextures(CompoundTag owner, UUID uuid) {
        CompoundTag properties = (CompoundTag)owner.get("Properties");
        if (properties == null) {
            if (uuid != null && uuid.version() == 4) {
                String uuidString = uuid.toString().replace("-", "");
                return SkinProvider.requestTexturesFromUUID(uuidString);
            }
            Object uuidString = owner.get("Name");
            if (uuidString instanceof StringTag) {
                StringTag nameTag = (StringTag)uuidString;
                return SkinProvider.requestTexturesFromUsername(nameTag.getValue());
            }
            return CompletableFuture.completedFuture(null);
        }
        ListTag textures = (ListTag)properties.get("textures");
        LinkedHashMap tag1 = (LinkedHashMap)((Tag)textures.get(0)).getValue();
        StringTag texture = (StringTag)tag1.get("Value");
        return CompletableFuture.completedFuture(texture.getValue());
    }

    public static @Nullable BlockDefinition translateSkull(GeyserSession session, CompoundTag tag, Vector3i blockPosition, int blockState) {
        CompoundTag owner = (CompoundTag)tag.get("SkullOwner");
        if (owner == null) {
            session.getSkullCache().removeSkull(blockPosition);
            return null;
        }
        UUID uuid = SkullBlockEntityTranslator.getUUID(owner);
        CompletableFuture<String> texturesFuture = SkullBlockEntityTranslator.getTextures(owner, uuid);
        if (texturesFuture.isDone()) {
            try {
                String texture = texturesFuture.get();
                if (texture == null) {
                    session.getGeyser().getLogger().debug("Custom skull with invalid SkullOwner tag: " + blockPosition + " " + tag);
                    return null;
                }
                SkullCache.Skull skull = session.getSkullCache().putSkull(blockPosition, uuid, texture, blockState);
                return skull.getBlockDefinition();
            }
            catch (InterruptedException | ExecutionException e) {
                session.getGeyser().getLogger().debug("Failed to acquire textures for custom skull: " + blockPosition + " " + tag);
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        texturesFuture.whenComplete((texturesProperty, throwable) -> {
            if (texturesProperty == null) {
                session.getGeyser().getLogger().debug("Custom skull with invalid SkullOwner tag: " + blockPosition + " " + tag);
                return;
            }
            if (session.getEventLoop().inEventLoop()) {
                SkullBlockEntityTranslator.putSkull(session, blockPosition, uuid, texturesProperty, blockState);
            } else {
                session.executeInEventLoop(() -> SkullBlockEntityTranslator.putSkull(session, blockPosition, uuid, texturesProperty, blockState));
            }
        });
        return null;
    }

    private static void putSkull(GeyserSession session, Vector3i blockPosition, UUID uuid, String texturesProperty, int blockState) {
        SkullCache.Skull skull = session.getSkullCache().putSkull(blockPosition, uuid, texturesProperty, blockState);
        if (skull.getBlockDefinition() != null) {
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.setDataLayer(0);
            updateBlockPacket.setBlockPosition(blockPosition);
            updateBlockPacket.setDefinition(skull.getBlockDefinition());
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
            session.sendUpstreamPacket(updateBlockPacket);
        }
    }
}

