/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.ProvidedSkins;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class SkinProvider {
    private static final boolean ALLOW_THIRD_PARTY_CAPES = GeyserImpl.getInstance().getConfig().isAllowThirdPartyCapes();
    private static ExecutorService EXECUTOR_SERVICE;
    static final Skin EMPTY_SKIN;
    static final Cape EMPTY_CAPE;
    private static final Cache<String, Cape> CACHED_JAVA_CAPES;
    private static final Cache<String, Skin> CACHED_JAVA_SKINS;
    private static final Cache<String, Cape> CACHED_BEDROCK_CAPES;
    private static final Cache<String, Skin> CACHED_BEDROCK_SKINS;
    private static final Map<String, CompletableFuture<Cape>> requestedCapes;
    private static final Map<String, CompletableFuture<Skin>> requestedSkins;
    private static final Map<UUID, SkinGeometry> cachedGeometry;
    private static final Predicate<UUID> IS_NPC;
    private static final boolean ALLOW_THIRD_PARTY_EARS;
    private static final String EARS_GEOMETRY;
    private static final String EARS_GEOMETRY_SLIM;
    static final SkinGeometry SKULL_GEOMETRY;
    static final SkinGeometry WEARING_CUSTOM_SKULL;
    static final SkinGeometry WEARING_CUSTOM_SKULL_SLIM;

    public static ExecutorService getExecutorService() {
        if (EXECUTOR_SERVICE == null) {
            EXECUTOR_SERVICE = Executors.newFixedThreadPool(ALLOW_THIRD_PARTY_CAPES ? 21 : 14);
        }
        return EXECUTOR_SERVICE;
    }

    public static void shutdown() {
        if (EXECUTOR_SERVICE != null) {
            EXECUTOR_SERVICE.shutdown();
            EXECUTOR_SERVICE = null;
        }
    }

    public static void registerCacheImageTask(GeyserImpl geyser) {
        if (geyser.getConfig().getCacheImages() > 0) {
            geyser.getScheduledThread().scheduleAtFixedRate(() -> {
                File cacheFolder = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("images").toFile();
                if (!cacheFolder.exists()) {
                    return;
                }
                int count = 0;
                long expireTime = (long)GeyserImpl.getInstance().getConfig().getCacheImages() * 86400000L;
                for (File imageFile : Objects.requireNonNull(cacheFolder.listFiles())) {
                    if (imageFile.lastModified() >= System.currentTimeMillis() - expireTime) continue;
                    imageFile.delete();
                    ++count;
                }
                if (count > 0) {
                    GeyserImpl.getInstance().getLogger().debug(String.format("Removed %d cached image files as they have expired", count));
                }
            }, 10L, 1440L, TimeUnit.MINUTES);
        }
    }

    static Skin getCachedSkin(String skinUrl) {
        return (Skin)CACHED_JAVA_SKINS.getIfPresent((Object)skinUrl);
    }

    static SkinData determineFallbackSkinData(UUID uuid) {
        GeyserSession session;
        Skin skin = null;
        Cape cape = null;
        SkinGeometry geometry = SkinGeometry.WIDE;
        if (GeyserImpl.getInstance().getConfig().getRemote().authType() != AuthType.ONLINE && (session = GeyserImpl.getInstance().connectionByUuid(uuid)) != null) {
            String skinId = session.getClientData().getSkinId();
            skin = (Skin)CACHED_BEDROCK_SKINS.getIfPresent((Object)skinId);
            String capeId = session.getClientData().getCapeId();
            cape = (Cape)CACHED_BEDROCK_CAPES.getIfPresent((Object)capeId);
            geometry = cachedGeometry.getOrDefault(uuid, geometry);
        }
        if (skin == null) {
            ProvidedSkins.ProvidedSkin providedSkin = ProvidedSkins.getDefaultPlayerSkin(uuid);
            skin = providedSkin.getData();
            SkinGeometry skinGeometry = geometry = providedSkin.isSlim() ? SkinGeometry.SLIM : SkinGeometry.WIDE;
        }
        if (cape == null) {
            cape = EMPTY_CAPE;
        }
        return new SkinData(skin, cape, geometry);
    }

    private static @NonNull Cape getCachedBedrockCape(UUID uuid) {
        String capeId;
        Cape bedrockCape;
        GeyserSession session = GeyserImpl.getInstance().connectionByUuid(uuid);
        if (session != null && (bedrockCape = (Cape)CACHED_BEDROCK_CAPES.getIfPresent((Object)(capeId = session.getClientData().getCapeId()))) != null) {
            return bedrockCape;
        }
        return EMPTY_CAPE;
    }

    static @Nullable Cape getCachedCape(String capeUrl) {
        if (capeUrl == null) {
            return null;
        }
        return (Cape)CACHED_JAVA_CAPES.getIfPresent((Object)capeUrl);
    }

    static CompletableFuture<SkinData> requestSkinData(PlayerEntity entity) {
        SkinManager.GameProfileData data = SkinManager.GameProfileData.from(entity);
        if (data == null) {
            return CompletableFuture.completedFuture(SkinProvider.determineFallbackSkinData(entity.getUuid()));
        }
        return SkinProvider.requestSkinAndCape(entity.getUuid(), data.skinUrl(), data.capeUrl()).thenApplyAsync(skinAndCape -> {
            try {
                boolean checkForBedrock;
                Skin skin = skinAndCape.skin();
                Cape cape = skinAndCape.cape();
                SkinGeometry geometry = data.isAlex() ? SkinGeometry.SLIM : SkinGeometry.WIDE;
                boolean bl = checkForBedrock = entity.getUuid().version() != 4;
                if (cape.failed() && checkForBedrock) {
                    cape = SkinProvider.getCachedBedrockCape(entity.getUuid());
                }
                if (cape.failed() && ALLOW_THIRD_PARTY_CAPES) {
                    cape = SkinProvider.getOrDefault(SkinProvider.requestUnofficialCape(cape, entity.getUuid(), entity.getUsername(), false), EMPTY_CAPE, CapeProvider.VALUES.length * 3);
                }
                boolean isDeadmau5 = "deadmau5".equals(entity.getUsername());
                if (geometry.failed() && (ALLOW_THIRD_PARTY_EARS || isDeadmau5)) {
                    boolean isEars;
                    if (isDeadmau5) {
                        isEars = true;
                    } else {
                        skin = SkinProvider.getOrDefault(SkinProvider.requestUnofficialEars(skin, entity.getUuid(), entity.getUsername(), false), skin, 3);
                        isEars = skin.isEars();
                    }
                    if (isEars) {
                        geometry = SkinGeometry.getEars(data.isAlex());
                        SkinProvider.storeEarSkin(skin);
                        SkinProvider.storeEarGeometry(entity.getUuid(), data.isAlex());
                    }
                }
                return new SkinData(skin, cape, geometry);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), e);
                return new SkinData(skinAndCape.skin(), skinAndCape.cape(), null);
            }
        });
    }

    private static CompletableFuture<SkinAndCape> requestSkinAndCape(UUID playerId, String skinUrl, String capeUrl) {
        return CompletableFuture.supplyAsync(() -> {
            long time = System.currentTimeMillis();
            CapeProvider provider = capeUrl != null ? CapeProvider.MINECRAFT : null;
            SkinAndCape skinAndCape = new SkinAndCape(SkinProvider.getOrDefault(SkinProvider.requestSkin(playerId, skinUrl, false), EMPTY_SKIN, 5), SkinProvider.getOrDefault(SkinProvider.requestCape(capeUrl, provider, false), EMPTY_CAPE, 5));
            GeyserImpl.getInstance().getLogger().debug("Took " + (System.currentTimeMillis() - time) + "ms for " + playerId);
            return skinAndCape;
        }, SkinProvider.getExecutorService());
    }

    static CompletableFuture<Skin> requestSkin(UUID playerId, String textureUrl, boolean newThread) {
        CompletionStage<Skin> future;
        if (textureUrl == null || textureUrl.isEmpty()) {
            return CompletableFuture.completedFuture(EMPTY_SKIN);
        }
        CompletableFuture<Skin> requestedSkin = requestedSkins.get(textureUrl);
        if (requestedSkin != null) {
            return requestedSkin;
        }
        Skin cachedSkin = (Skin)CACHED_JAVA_SKINS.getIfPresent((Object)textureUrl);
        if (cachedSkin != null) {
            return CompletableFuture.completedFuture(cachedSkin);
        }
        if (newThread) {
            future = CompletableFuture.supplyAsync(() -> SkinProvider.supplySkin(playerId, textureUrl), SkinProvider.getExecutorService()).whenCompleteAsync((skin, throwable) -> {
                skin.updated = true;
                CACHED_JAVA_SKINS.put((Object)textureUrl, skin);
                requestedSkins.remove(textureUrl);
            });
            requestedSkins.put(textureUrl, (CompletableFuture<Skin>)future);
        } else {
            Skin skin2 = SkinProvider.supplySkin(playerId, textureUrl);
            future = CompletableFuture.completedFuture(skin2);
            CACHED_JAVA_SKINS.put((Object)textureUrl, (Object)skin2);
        }
        return future;
    }

    private static CompletableFuture<Cape> requestCape(String capeUrl, CapeProvider provider, boolean newThread) {
        CompletionStage<Cape> future;
        if (capeUrl == null || capeUrl.isEmpty()) {
            return CompletableFuture.completedFuture(EMPTY_CAPE);
        }
        CompletableFuture<Cape> requestedCape = requestedCapes.get(capeUrl);
        if (requestedCape != null) {
            return requestedCape;
        }
        Cape cachedCape = (Cape)CACHED_JAVA_CAPES.getIfPresent((Object)capeUrl);
        if (cachedCape != null) {
            return CompletableFuture.completedFuture(cachedCape);
        }
        if (newThread) {
            future = CompletableFuture.supplyAsync(() -> SkinProvider.supplyCape(capeUrl, provider), SkinProvider.getExecutorService()).whenCompleteAsync((cape, throwable) -> {
                CACHED_JAVA_CAPES.put((Object)capeUrl, cape);
                requestedCapes.remove(capeUrl);
            });
            requestedCapes.put(capeUrl, (CompletableFuture<Cape>)future);
        } else {
            Cape cape2 = SkinProvider.supplyCape(capeUrl, provider);
            future = CompletableFuture.completedFuture(cape2);
            CACHED_JAVA_CAPES.put((Object)capeUrl, (Object)cape2);
        }
        return future;
    }

    private static CompletableFuture<Cape> requestUnofficialCape(Cape officialCape, UUID playerId, String username, boolean newThread) {
        if (officialCape.failed() && ALLOW_THIRD_PARTY_CAPES) {
            for (CapeProvider provider : CapeProvider.VALUES) {
                Cape cape1;
                if (provider.type != CapeUrlType.USERNAME && IS_NPC.test(playerId) || (cape1 = SkinProvider.getOrDefault(SkinProvider.requestCape(provider.getUrlFor(playerId, username), provider, newThread), EMPTY_CAPE, 4)).failed()) continue;
                return CompletableFuture.completedFuture(cape1);
            }
        }
        return CompletableFuture.completedFuture(officialCape);
    }

    private static CompletableFuture<Skin> requestEars(String earsUrl, boolean newThread, Skin skin) {
        CompletionStage<Skin> future;
        if (earsUrl == null || earsUrl.isEmpty()) {
            return CompletableFuture.completedFuture(skin);
        }
        if (newThread) {
            future = CompletableFuture.supplyAsync(() -> SkinProvider.supplyEars(skin, earsUrl), SkinProvider.getExecutorService()).whenCompleteAsync((outSkin, throwable) -> {});
        } else {
            Skin ears = SkinProvider.supplyEars(skin, earsUrl);
            future = CompletableFuture.completedFuture(ears);
        }
        return future;
    }

    private static CompletableFuture<Skin> requestUnofficialEars(Skin officialSkin, UUID playerId, String username, boolean newThread) {
        for (EarsProvider provider : EarsProvider.VALUES) {
            Skin skin1;
            if (provider.type != CapeUrlType.USERNAME && IS_NPC.test(playerId) || !(skin1 = SkinProvider.getOrDefault(SkinProvider.requestEars(provider.getUrlFor(playerId, username), newThread, officialSkin), officialSkin, 4)).isEars()) continue;
            return CompletableFuture.completedFuture(skin1);
        }
        return CompletableFuture.completedFuture(officialSkin);
    }

    static void storeBedrockSkin(UUID playerID, String skinId, byte[] skinData) {
        Skin skin = new Skin(playerID, skinId, skinData, System.currentTimeMillis(), true, false);
        CACHED_BEDROCK_SKINS.put((Object)skin.getTextureUrl(), (Object)skin);
    }

    static void storeBedrockCape(String capeId, byte[] capeData) {
        Cape cape = new Cape(capeId, capeId, capeData, System.currentTimeMillis(), false);
        CACHED_BEDROCK_CAPES.put((Object)capeId, (Object)cape);
    }

    static void storeBedrockGeometry(UUID playerID, byte[] geometryName, byte[] geometryData) {
        SkinGeometry geometry = new SkinGeometry(new String(geometryName), new String(geometryData), false);
        cachedGeometry.put(playerID, geometry);
    }

    public static void storeEarSkin(Skin skin) {
        CACHED_JAVA_SKINS.put((Object)skin.getTextureUrl(), (Object)skin);
    }

    private static void storeEarGeometry(UUID playerID, boolean isSlim) {
        cachedGeometry.put(playerID, SkinGeometry.getEars(isSlim));
    }

    private static Skin supplySkin(UUID uuid, String textureUrl) {
        try {
            byte[] skin = SkinProvider.requestImageData(textureUrl, null);
            return new Skin(uuid, textureUrl, skin, System.currentTimeMillis(), false, false);
        }
        catch (Exception exception) {
            return new Skin(uuid, "empty", EMPTY_SKIN.getSkinData(), System.currentTimeMillis(), false, false);
        }
    }

    private static Cape supplyCape(String capeUrl, CapeProvider provider) {
        byte[] cape = EMPTY_CAPE.capeData();
        try {
            cape = SkinProvider.requestImageData(capeUrl, provider);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] urlSection = capeUrl.split("/");
        return new Cape(capeUrl, urlSection[urlSection.length - 1], cape, System.currentTimeMillis(), cape.length == 0);
    }

    private static Skin supplyEars(Skin existingSkin, String earsUrl) {
        try {
            BufferedImage ears = ImageIO.read(new URL(earsUrl));
            if (ears == null) {
                throw new NullPointerException();
            }
            int height = existingSkin.getSkinData().length / 4 / 64;
            BufferedImage skinImage = SkinProvider.imageDataToBufferedImage(existingSkin.getSkinData(), 64, height);
            BufferedImage newSkin = new BufferedImage(skinImage.getWidth(), skinImage.getHeight(), 2);
            Graphics2D g = (Graphics2D)newSkin.getGraphics();
            g.drawImage((Image)skinImage, 0, 0, null);
            g.drawImage((Image)ears, 24, 0, null);
            byte[] data = SkinProvider.bufferedImageToImageData(newSkin);
            skinImage.flush();
            return new Skin(existingSkin.getSkinOwner(), existingSkin.getTextureUrl(), data, System.currentTimeMillis(), true, true);
        }
        catch (Exception exception) {
            return existingSkin;
        }
    }

    public static BufferedImage requestImage(String imageUrl, CapeProvider provider) throws IOException {
        BufferedImage image = null;
        File imageFile = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("images").resolve(UUID.nameUUIDFromBytes(imageUrl.getBytes()) + ".png").toFile();
        if (imageFile.exists()) {
            try {
                GeyserImpl.getInstance().getLogger().debug("Reading cached image from file " + imageFile.getPath() + " for " + imageUrl);
                imageFile.setLastModified(System.currentTimeMillis());
                image = ImageIO.read(imageFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            image = SkinProvider.downloadImage(imageUrl, provider);
            GeyserImpl.getInstance().getLogger().debug("Downloaded " + imageUrl);
            if (GeyserImpl.getInstance().getConfig().getCacheImages() > 0) {
                imageFile.getParentFile().mkdirs();
                try {
                    ImageIO.write((RenderedImage)image, "png", imageFile);
                    GeyserImpl.getInstance().getLogger().debug("Writing cached skin to file " + imageFile.getPath() + " for " + imageUrl);
                }
                catch (IOException e) {
                    GeyserImpl.getInstance().getLogger().error("Failed to write cached skin to file " + imageFile.getPath() + " for " + imageUrl);
                }
            }
        }
        if (provider != null) {
            if (image.getWidth() > 64 || image.getHeight() > 32) {
                newImage = new BufferedImage(128, 64, 2);
                Graphics2D g = newImage.createGraphics();
                g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                g.dispose();
                image.flush();
                image = SkinProvider.scale(newImage, 64, 32);
            } else if (image.getWidth() < 64 || image.getHeight() < 32) {
                newImage = new BufferedImage(64, 32, 2);
                Graphics2D g = newImage.createGraphics();
                g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                g.dispose();
                image.flush();
                image = newImage;
            }
        } else if (image.getWidth() > 128) {
            image = SkinProvider.scale(image, 128, image.getHeight() >= 256 ? image.getHeight() / (image.getWidth() / 128) : 128);
        }
        return image;
    }

    private static byte[] requestImageData(String imageUrl, CapeProvider provider) throws Exception {
        BufferedImage image = SkinProvider.requestImage(imageUrl, provider);
        byte[] data = SkinProvider.bufferedImageToImageData(image);
        image.flush();
        return data;
    }

    public static CompletableFuture<@Nullable String> requestTexturesFromUUID(String uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonNode node = WebUtils.getJson("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
                JsonNode properties = node.get("properties");
                if (properties == null) {
                    GeyserImpl.getInstance().getLogger().debug("No properties found in Mojang response for " + uuid);
                    return null;
                }
                return node.get("properties").get(0).get("value").asText();
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().debug("Unable to request textures for " + uuid);
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }, SkinProvider.getExecutorService());
    }

    public static CompletableFuture<@Nullable String> requestTexturesFromUsername(String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonNode node = WebUtils.getJson("https://api.mojang.com/users/profiles/minecraft/" + username);
                JsonNode id = node.get("id");
                if (id == null) {
                    GeyserImpl.getInstance().getLogger().debug("No UUID found in Mojang response for " + username);
                    return null;
                }
                return id.asText();
            }
            catch (Exception e) {
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }, SkinProvider.getExecutorService()).thenCompose(uuid -> {
            if (uuid == null) {
                return CompletableFuture.completedFuture(null);
            }
            return SkinProvider.requestTexturesFromUUID(uuid);
        });
    }

    private static BufferedImage downloadImage(String imageUrl, CapeProvider provider) throws IOException {
        BufferedImage image;
        if (provider == CapeProvider.FIVEZIG) {
            image = SkinProvider.readFiveZigCape(imageUrl);
        } else {
            HttpURLConnection con = (HttpURLConnection)new URL(imageUrl).openConnection();
            con.setRequestProperty("User-Agent", "Geyser-" + GeyserImpl.getInstance().getPlatformType().toString() + "/2.2.2-SNAPSHOT (git-master-19c6648)");
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            image = ImageIO.read(con.getInputStream());
        }
        if (image == null) {
            throw new IllegalArgumentException("Failed to read image from: %s (cape provider=%s)".formatted(new Object[]{imageUrl, provider}));
        }
        return image;
    }

    private static @Nullable BufferedImage readFiveZigCape(String url) throws IOException {
        JsonNode element = GeyserImpl.JSON_MAPPER.readTree(WebUtils.getBody(url));
        if (element != null && element.isObject()) {
            JsonNode capeElement = element.get("d");
            if (capeElement == null || capeElement.isNull()) {
                return null;
            }
            return ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(capeElement.textValue())));
        }
        return null;
    }

    public static BufferedImage scale(BufferedImage bufferedImage, int newWidth, int newHeight) {
        BufferedImage resized = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2 = resized.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
        g2.dispose();
        bufferedImage.flush();
        return resized;
    }

    private static int getRGBA(int index, byte[] data) {
        return (data[index] & 0xFF) << 16 | (data[index + 1] & 0xFF) << 8 | data[index + 2] & 0xFF | (data[index + 3] & 0xFF) << 24;
    }

    public static BufferedImage imageDataToBufferedImage(byte[] imageData, int imageWidth, int imageHeight) {
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        int index = 0;
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                image.setRGB(x, y, SkinProvider.getRGBA(index, imageData));
                index += 4;
            }
        }
        return image;
    }

    public static byte[] bufferedImageToImageData(BufferedImage image) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(image.getWidth() * 4 + image.getHeight() * 4);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgba = image.getRGB(x, y);
                outputStream.write(rgba >> 16 & 0xFF);
                outputStream.write(rgba >> 8 & 0xFF);
                outputStream.write(rgba & 0xFF);
                outputStream.write(rgba >> 24 & 0xFF);
            }
        }
        return outputStream.toByteArray();
    }

    public static <T> T getOrDefault(CompletableFuture<T> future, T defaultValue, int timeoutInSeconds) {
        try {
            return future.get(timeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    static {
        EMPTY_CAPE = new Cape("", "no-cape", ByteArrays.EMPTY_ARRAY, -1L, true);
        CACHED_JAVA_CAPES = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        CACHED_JAVA_SKINS = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        CACHED_BEDROCK_CAPES = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        CACHED_BEDROCK_SKINS = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        requestedCapes = new ConcurrentHashMap<String, CompletableFuture<Cape>>();
        requestedSkins = new ConcurrentHashMap<String, CompletableFuture<Skin>>();
        cachedGeometry = new ConcurrentHashMap<UUID, SkinGeometry>();
        IS_NPC = uuid -> uuid.version() == 2;
        ALLOW_THIRD_PARTY_EARS = GeyserImpl.getInstance().getConfig().isAllowThirdPartyEars();
        int pink = -524040;
        int black = -16777216;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(512);
        for (int y = 0; y < 64; ++y) {
            for (int x = 0; x < 64; ++x) {
                int rgba = y > 32 ? (x >= 32 ? -524040 : -16777216) : (x >= 32 ? -16777216 : -524040);
                outputStream.write(rgba >> 16 & 0xFF);
                outputStream.write(rgba >> 8 & 0xFF);
                outputStream.write(rgba & 0xFF);
                outputStream.write(rgba >> 24 & 0xFF);
            }
        }
        EMPTY_SKIN = new Skin(-1L, "geysermc:empty", outputStream.toByteArray());
        EARS_GEOMETRY = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.ears.json"), StandardCharsets.UTF_8);
        EARS_GEOMETRY_SLIM = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.earsSlim.json"), StandardCharsets.UTF_8);
        String skullData = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.customskull.json"), StandardCharsets.UTF_8);
        SKULL_GEOMETRY = new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.customskull\"}}", skullData, false);
        String wearingCustomSkull = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.wearingCustomSkull.json"), StandardCharsets.UTF_8);
        WEARING_CUSTOM_SKULL = new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.wearingCustomSkull\"}}", wearingCustomSkull, false);
        String wearingCustomSkullSlim = new String(FileUtils.readAllBytes("bedrock/skin/geometry.humanoid.wearingCustomSkullSlim.json"), StandardCharsets.UTF_8);
        WEARING_CUSTOM_SKULL_SLIM = new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.wearingCustomSkullSlim\"}}", wearingCustomSkullSlim, false);
    }

    public static class Skin {
        private UUID skinOwner;
        private final String textureUrl;
        private final byte[] skinData;
        private final long requestedOn;
        private boolean updated;
        private boolean ears;

        Skin(long requestedOn, String textureUrl, byte[] skinData) {
            this.requestedOn = requestedOn;
            this.textureUrl = textureUrl;
            this.skinData = skinData;
        }

        public Skin(UUID skinOwner, String textureUrl, byte[] skinData, long requestedOn, boolean updated, boolean ears) {
            this.skinOwner = skinOwner;
            this.textureUrl = textureUrl;
            this.skinData = skinData;
            this.requestedOn = requestedOn;
            this.updated = updated;
            this.ears = ears;
        }

        public UUID getSkinOwner() {
            return this.skinOwner;
        }

        public String getTextureUrl() {
            return this.textureUrl;
        }

        public byte[] getSkinData() {
            return this.skinData;
        }

        public long getRequestedOn() {
            return this.requestedOn;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public boolean isEars() {
            return this.ears;
        }
    }

    public record SkinGeometry(String geometryName, String geometryData, boolean failed) {
        public static SkinGeometry WIDE = SkinGeometry.getLegacy(false);
        public static SkinGeometry SLIM = SkinGeometry.getLegacy(true);

        private static SkinGeometry getLegacy(boolean isSlim) {
            return new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.custom" + (isSlim ? "Slim" : "") + "\"}}", "", true);
        }

        private static SkinGeometry getEars(boolean isSlim) {
            return new SkinGeometry("{\"geometry\" :{\"default\" :\"geometry.humanoid.ears" + (isSlim ? "Slim" : "") + "\"}}", isSlim ? EARS_GEOMETRY_SLIM : EARS_GEOMETRY, false);
        }
    }

    public record Cape(String textureUrl, String capeId, byte[] capeData, long requestedOn, boolean failed) {
    }

    public record SkinData(Skin skin, Cape cape, SkinGeometry geometry) {
    }

    public static enum CapeProvider {
        MINECRAFT,
        OPTIFINE("https://optifine.net/capes/%s.png", CapeUrlType.USERNAME),
        LABYMOD("https://dl.labymod.net/capes/%s", CapeUrlType.UUID_DASHED),
        FIVEZIG("https://textures.5zigreborn.eu/profile/%s", CapeUrlType.UUID_DASHED),
        MINECRAFTCAPES("https://api.minecraftcapes.net/profile/%s/cape", CapeUrlType.UUID);

        public static final CapeProvider[] VALUES;
        private String url;
        private CapeUrlType type;

        public String getUrlFor(String type) {
            return String.format(this.url, type);
        }

        public String getUrlFor(UUID uuid, String username) {
            return this.getUrlFor(CapeProvider.toRequestedType(this.type, uuid, username));
        }

        public static String toRequestedType(CapeUrlType type, UUID uuid, String username) {
            return switch (type) {
                case CapeUrlType.UUID -> uuid.toString().replace("-", "");
                case CapeUrlType.UUID_DASHED -> uuid.toString();
                default -> username;
            };
        }

        private CapeProvider(String url, CapeUrlType type) {
            this.url = url;
            this.type = type;
        }

        private CapeProvider() {
        }

        public String getUrl() {
            return this.url;
        }

        public CapeUrlType getType() {
            return this.type;
        }

        static {
            VALUES = Arrays.copyOfRange(CapeProvider.values(), 1, 5);
        }
    }

    public static enum CapeUrlType {
        USERNAME,
        UUID,
        UUID_DASHED;

    }

    public static enum EarsProvider {
        MINECRAFTCAPES("https://api.minecraftcapes.net/profile/%s/ears", CapeUrlType.UUID);

        public static final EarsProvider[] VALUES;
        private String url;
        private CapeUrlType type;

        public String getUrlFor(String type) {
            return String.format(this.url, type);
        }

        public String getUrlFor(UUID uuid, String username) {
            return this.getUrlFor(EarsProvider.toRequestedType(this.type, uuid, username));
        }

        public static String toRequestedType(CapeUrlType type, UUID uuid, String username) {
            return switch (type) {
                case CapeUrlType.UUID -> uuid.toString().replace("-", "");
                case CapeUrlType.UUID_DASHED -> uuid.toString();
                default -> username;
            };
        }

        private EarsProvider(String url, CapeUrlType type) {
            this.url = url;
            this.type = type;
        }

        private EarsProvider() {
        }

        public String getUrl() {
            return this.url;
        }

        public CapeUrlType getType() {
            return this.type;
        }

        static {
            VALUES = EarsProvider.values();
        }
    }

    public record SkinAndCape(Skin skin, Cape cape) {
    }
}

