/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.github.steveice10.mc.auth.exception.request.AuthPendingException;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.MsaAuthenticationService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;

public class PendingMicrosoftAuthentication {
    private boolean storeServerInformation = false;
    private final LoadingCache<String, AuthenticationTask> authentications;

    public PendingMicrosoftAuthentication(final int timeoutSeconds) {
        this.authentications = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AuthenticationTask>(){

            public AuthenticationTask load(@NonNull String userKey) {
                return PendingMicrosoftAuthentication.this.storeServerInformation ? new ProxyAuthenticationTask(userKey, (long)timeoutSeconds * 1000L) : new AuthenticationTask(userKey, (long)timeoutSeconds * 1000L);
            }
        });
    }

    public AuthenticationTask getTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.getIfPresent((Object)userKey);
    }

    public AuthenticationTask getOrCreateTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.get((Object)userKey);
    }

    public void setStoreServerInformation() {
        this.storeServerInformation = true;
    }

    public class AuthenticationTask {
        private static final Executor DELAYED_BY_ONE_SECOND = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
        private final MsaAuthenticationService msaAuthenticationService = new MsaAuthenticationService("204cefd1-4818-4de1-b98d-513fae875d88");
        private final String userKey;
        private final long timeoutMs;
        private long remainingTimeMs;
        private boolean online = true;
        private final CompletableFuture<MsaAuthenticationService> authentication;
        private volatile Throwable loginException;

        private AuthenticationTask(String userKey, long timeoutMs) {
            this.userKey = userKey;
            this.timeoutMs = timeoutMs;
            this.remainingTimeMs = timeoutMs;
            this.authentication = new CompletableFuture();
            this.authentication.whenComplete((r, ex) -> {
                this.loginException = ex;
                CompletableFuture.delayedExecutor(timeoutMs, TimeUnit.MILLISECONDS).execute(this::cleanup);
            });
        }

        public void resetTimer() {
            this.remainingTimeMs = this.timeoutMs;
        }

        public void cleanup() {
            GeyserLogger logger = GeyserImpl.getInstance().getLogger();
            if (logger.isDebug()) {
                logger.debug("Cleaning up authentication task for " + this.userKey);
            }
            PendingMicrosoftAuthentication.this.authentications.invalidate((Object)this.userKey);
        }

        public CompletableFuture<MsaAuthenticationService.MsCodeResponse> getCode(boolean offlineAccess) {
            CompletableFuture<MsaAuthenticationService.MsCodeResponse> code = CompletableFuture.supplyAsync(() -> this.tryGetCode(offlineAccess));
            code.thenRun(() -> this.performLoginAttempt(System.currentTimeMillis()));
            return code;
        }

        private MsaAuthenticationService.MsCodeResponse tryGetCode(boolean offlineAccess) throws CompletionException {
            try {
                return this.msaAuthenticationService.getAuthCode(offlineAccess);
            }
            catch (RequestException e) {
                throw new CompletionException(e);
            }
        }

        private void performLoginAttempt(long lastAttempt) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.msaAuthenticationService.login();
                }
                catch (AuthPendingException e) {
                    long currentAttempt = System.currentTimeMillis();
                    if (!this.online) {
                        this.remainingTimeMs -= currentAttempt - lastAttempt;
                        if (this.remainingTimeMs <= 0L) {
                            this.authentication.completeExceptionally(new TaskTimeoutException());
                            this.cleanup();
                            return;
                        }
                    }
                    this.performLoginAttempt(currentAttempt);
                    return;
                }
                catch (Exception e) {
                    this.authentication.completeExceptionally(e);
                    return;
                }
                this.authentication.complete(this.msaAuthenticationService);
            }, DELAYED_BY_ONE_SECOND);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{userKey='" + this.userKey + "'}";
        }

        public MsaAuthenticationService getMsaAuthenticationService() {
            return this.msaAuthenticationService;
        }

        public void setOnline(boolean online) {
            this.online = online;
        }

        public CompletableFuture<MsaAuthenticationService> getAuthentication() {
            return this.authentication;
        }

        public Throwable getLoginException() {
            return this.loginException;
        }
    }

    public static class TaskTimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        TaskTimeoutException() {
            super("It took too long to authorize Geyser to access your Microsoft account. Please request new code and try again.");
        }
    }

    public final class ProxyAuthenticationTask
    extends AuthenticationTask {
        private String server;
        private int port;

        private ProxyAuthenticationTask(String userKey, long timeoutMs) {
            super(userKey, timeoutMs);
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

