/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.PotionMixData;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;

public class PotionMixRegistryLoader
implements RegistryLoader<Object, Int2ObjectMap<Set<PotionMixData>>> {
    @Override
    public Int2ObjectMap<Set<PotionMixData>> load(Object input) {
        Int2ObjectOpenHashMap<Set<PotionMixData>> allPotionMixes = new Int2ObjectOpenHashMap<Set<PotionMixData>>(((Int2ObjectMap)Registries.ITEMS.get()).size());
        for (Int2ObjectMap.Entry entry : ((Int2ObjectMap)Registries.ITEMS.get()).int2ObjectEntrySet()) {
            ItemMappings mappings = (ItemMappings)entry.getValue();
            ArrayList<ItemMapping> ingredients = new ArrayList<ItemMapping>();
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.NETHER_WART));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.REDSTONE));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.GLOWSTONE_DUST));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.FERMENTED_SPIDER_EYE));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.GUNPOWDER));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.DRAGON_BREATH));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.SUGAR));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.RABBIT_FOOT));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.GLISTERING_MELON_SLICE));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.SPIDER_EYE));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.PUFFERFISH));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.MAGMA_CREAM));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.GOLDEN_CARROT));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.BLAZE_POWDER));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.GHAST_TEAR));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.TURTLE_HELMET));
            ingredients.add(PotionMixRegistryLoader.getNonNull(mappings, Items.PHANTOM_MEMBRANE));
            List<ItemMapping> inputs = List.of(PotionMixRegistryLoader.getNonNull(mappings, Items.POTION), PotionMixRegistryLoader.getNonNull(mappings, Items.SPLASH_POTION), PotionMixRegistryLoader.getNonNull(mappings, Items.LINGERING_POTION));
            ItemMapping glassBottle = PotionMixRegistryLoader.getNonNull(mappings, Items.GLASS_BOTTLE);
            HashSet<PotionMixData> potionMixes = new HashSet<PotionMixData>();
            ItemMapping fillerIngredient = (ItemMapping)ingredients.get(0);
            for (ItemMapping entryInput : inputs) {
                for (Potion potion : Potion.VALUES) {
                    potionMixes.add(new PotionMixData(entryInput.getBedrockDefinition().getRuntimeId(), potion.getBedrockId(), fillerIngredient.getBedrockDefinition().getRuntimeId(), fillerIngredient.getBedrockData(), glassBottle.getBedrockDefinition().getRuntimeId(), glassBottle.getBedrockData()));
                }
            }
            for (ItemMapping ingredient : ingredients) {
                potionMixes.add(new PotionMixData(glassBottle.getBedrockDefinition().getRuntimeId(), glassBottle.getBedrockData(), ingredient.getBedrockDefinition().getRuntimeId(), ingredient.getBedrockData(), glassBottle.getBedrockDefinition().getRuntimeId(), glassBottle.getBedrockData()));
            }
            allPotionMixes.put(entry.getIntKey(), (Set<PotionMixData>)potionMixes);
        }
        allPotionMixes.trim();
        return allPotionMixes;
    }

    private static ItemMapping getNonNull(ItemMappings mappings, Item javaItem) {
        ItemMapping itemMapping = mappings.getMapping(javaItem);
        if (itemMapping == null) {
            throw new NullPointerException("No item entry exists for java identifier: " + javaItem.javaIdentifier());
        }
        return itemMapping;
    }
}

