/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.EffectRegistryLoader;
import org.geysermc.geyser.registry.type.ParticleMapping;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class ParticleTypesRegistryLoader
extends EffectRegistryLoader<Map<com.github.steveice10.mc.protocol.data.game.level.particle.ParticleType, ParticleMapping>> {
    @Override
    public Map<com.github.steveice10.mc.protocol.data.game.level.particle.ParticleType, ParticleMapping> load(String input) {
        this.loadFile(input);
        Iterator<Map.Entry<String, JsonNode>> particlesIterator = this.get(input).fields();
        Object2ObjectOpenHashMap particles = new Object2ObjectOpenHashMap();
        try {
            while (particlesIterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = particlesIterator.next();
                String key = entry.getKey().toUpperCase(Locale.ROOT);
                JsonNode bedrockId = entry.getValue().get("bedrockId");
                JsonNode eventType = entry.getValue().get("eventType");
                if (eventType == null && bedrockId == null) {
                    GeyserImpl.getInstance().getLogger().debug("Skipping particle mapping " + key + " because no Bedrock equivalent exists.");
                    continue;
                }
                Enum type = null;
                if (eventType != null) {
                    try {
                        type = ParticleType.valueOf(eventType.asText().toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException ex) {
                        type = LevelEvent.valueOf(eventType.asText().toUpperCase(Locale.ROOT));
                    }
                }
                particles.put(com.github.steveice10.mc.protocol.data.game.level.particle.ParticleType.valueOf(key), new ParticleMapping((LevelEventType)((Object)type), bedrockId == null ? null : bedrockId.asText()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return particles;
    }
}

