/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.fabric;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.fabric.GeyserFabricConfiguration;
import org.geysermc.geyser.platform.fabric.GeyserFabricDumpInfo;
import org.geysermc.geyser.platform.fabric.GeyserFabricLogger;
import org.geysermc.geyser.platform.fabric.GeyserFabricUpdateListener;
import org.geysermc.geyser.platform.fabric.GeyserServerPortGetter;
import org.geysermc.geyser.platform.fabric.ModPingPassthrough;
import org.geysermc.geyser.platform.fabric.command.GeyserFabricCommandExecutor;
import org.geysermc.geyser.platform.fabric.world.GeyserFabricWorldManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class GeyserFabricMod
implements ModInitializer,
GeyserBootstrap {
    private static GeyserFabricMod instance;
    private boolean reloading;
    private GeyserImpl geyser;
    private ModContainer mod;
    private Path dataFolder;
    private MinecraftServer server;
    private GeyserCommandManager geyserCommandManager;
    private GeyserFabricConfiguration geyserConfig;
    private GeyserFabricLogger geyserLogger;
    private IGeyserPingPassthrough geyserPingPassthrough;
    private WorldManager geyserWorldManager;

    public void onInitialize() {
        instance = this;
        this.mod = (ModContainer)FabricLoader.getInstance().getModContainer("geyser-fabric").orElseThrow();
        this.onEnable();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerLifecycleEvents.SERVER_STARTED.register(this::startGeyser);
        }
    }

    @Override
    public void onEnable() {
        this.dataFolder = FabricLoader.getInstance().getConfigDir().resolve("Geyser-Fabric");
        if (!this.dataFolder.toFile().exists()) {
            this.dataFolder.toFile().mkdir();
        }
        GeyserLocale.init(this);
        try {
            File configFile = FileUtils.fileOrCopiedFromResource(this.dataFolder.resolve("config.yml").toFile(), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserFabricConfiguration.class);
        }
        catch (IOException ex) {
            LogManager.getLogger((String)"geyser-fabric").error(GeyserLocale.getLocaleStringLog("geyser.config.failed"), (Throwable)ex);
            ex.printStackTrace();
            return;
        }
        this.geyserLogger = new GeyserFabricLogger(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.geyser = GeyserImpl.load(PlatformType.FABRIC, this);
        if (this.server == null) {
            ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.onDisable());
            ServerPlayConnectionEvents.JOIN.register((handler, $, $$) -> GeyserFabricUpdateListener.onPlayReady(handler));
        } else {
            this.startGeyser(this.server);
            this.reloading = false;
        }
    }

    public void startGeyser(MinecraftServer server) {
        this.server = server;
        GeyserImpl.start();
        this.geyserPingPassthrough = this.geyserConfig.isLegacyPingPassthrough() ? GeyserLegacyPingPassthrough.init(this.geyser) : new ModPingPassthrough(server, this.geyserLogger);
        this.geyserCommandManager = new GeyserCommandManager(this.geyser);
        this.geyserCommandManager.init();
        this.geyserWorldManager = new GeyserFabricWorldManager(server);
        GeyserFabricCommandExecutor helpExecutor = new GeyserFabricCommandExecutor(this.geyser, (GeyserCommand)this.geyser.commandManager().getCommands().get("help"));
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"geyser").executes((com.mojang.brigadier.Command)helpExecutor);
        for (Map.Entry<String, Command> entry : this.geyser.commandManager().getCommands().entrySet()) {
            GeyserFabricCommandExecutor executor = new GeyserFabricCommandExecutor(this.geyser, (GeyserCommand)entry.getValue());
            builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)entry.getKey()).executes((com.mojang.brigadier.Command)executor)).requires(executor::testPermission)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(context -> executor.runWithArgs((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"args")))).requires(executor::testPermission)));
        }
        server.method_3734().method_9235().register(builder);
        for (Map.Entry<Object, Object> entry : this.geyser.commandManager().extensionCommands().entrySet()) {
            Map extensionCommands = (Map)entry.getValue();
            if (extensionCommands.isEmpty()) continue;
            GeyserFabricCommandExecutor extensionHelpExecutor = new GeyserFabricCommandExecutor(this.geyser, (GeyserCommand)extensionCommands.get("help"));
            LiteralArgumentBuilder extCmdBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)((Extension)entry.getKey()).description().id()).executes((com.mojang.brigadier.Command)extensionHelpExecutor);
            for (Map.Entry command : extensionCommands.entrySet()) {
                GeyserFabricCommandExecutor executor = new GeyserFabricCommandExecutor(this.geyser, (GeyserCommand)command.getValue());
                extCmdBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)((String)command.getKey())).executes((com.mojang.brigadier.Command)executor)).requires(executor::testPermission)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(context -> executor.runWithArgs((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"args")))).requires(executor::testPermission)));
            }
            server.method_3734().method_9235().register(extCmdBuilder);
        }
    }

    @Override
    public void onDisable() {
        if (this.geyser != null) {
            this.geyser.shutdown();
            this.geyser = null;
        }
        if (!this.reloading) {
            this.server = null;
        }
    }

    @Override
    public GeyserConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public GeyserCommandManager getGeyserCommandManager() {
        return this.geyserCommandManager;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserPingPassthrough;
    }

    @Override
    public WorldManager getWorldManager() {
        return this.geyserWorldManager;
    }

    @Override
    public Path getConfigFolder() {
        return this.dataFolder;
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserFabricDumpInfo(this.server);
    }

    @Override
    public String getMinecraftServerVersion() {
        return this.server.method_3827();
    }

    @Override
    public @NonNull String getServerBindAddress() {
        String ip = this.server.method_3819();
        return ip != null ? ip : "";
    }

    @Override
    public int getServerPort() {
        return ((GeyserServerPortGetter)this.server).geyser$getServerPort();
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        Optional floodgate = FabricLoader.getInstance().getModContainer("floodgate");
        if (floodgate.isPresent()) {
            this.geyserConfig.loadFloodgate(this, floodgate.orElse(null));
            return true;
        }
        return false;
    }

    @Override
    public @Nullable InputStream getResourceOrNull(String resource) {
        Path path = this.mod.findPath(resource).orElse(null);
        if (path == null) {
            return null;
        }
        try {
            return path.getFileSystem().provider().newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    public static GeyserFabricMod getInstance() {
        return instance;
    }
}

