/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum TippedArrowPotion {
    MUNDANE(2, ArrowParticleColors.NONE),
    THICK(4, ArrowParticleColors.NONE),
    AWKWARD(5, ArrowParticleColors.NONE),
    NIGHT_VISION(6, ArrowParticleColors.NIGHT_VISION),
    LONG_NIGHT_VISION(7, ArrowParticleColors.NIGHT_VISION),
    INVISIBILITY(8, ArrowParticleColors.INVISIBILITY),
    LONG_INVISIBILITY(9, ArrowParticleColors.INVISIBILITY),
    LEAPING(10, ArrowParticleColors.LEAPING),
    LONG_LEAPING(11, ArrowParticleColors.LEAPING),
    STRONG_LEAPING(12, ArrowParticleColors.LEAPING),
    FIRE_RESISTANCE(13, ArrowParticleColors.FIRE_RESISTANCE),
    LONG_FIRE_RESISTANCE(14, ArrowParticleColors.FIRE_RESISTANCE),
    SWIFTNESS(15, ArrowParticleColors.SWIFTNESS),
    LONG_SWIFTNESS(16, ArrowParticleColors.SWIFTNESS),
    STRONG_SWIFTNESS(17, ArrowParticleColors.SWIFTNESS),
    SLOWNESS(18, ArrowParticleColors.SLOWNESS),
    LONG_SLOWNESS(19, ArrowParticleColors.SLOWNESS),
    STRONG_SLOWNESS(43, ArrowParticleColors.SLOWNESS),
    WATER_BREATHING(20, ArrowParticleColors.WATER_BREATHING),
    LONG_WATER_BREATHING(21, ArrowParticleColors.WATER_BREATHING),
    HEALING(22, ArrowParticleColors.HEALING),
    STRONG_HEALING(23, ArrowParticleColors.HEALING),
    HARMING(24, ArrowParticleColors.HARMING),
    STRONG_HARMING(25, ArrowParticleColors.HARMING),
    POISON(26, ArrowParticleColors.POISON),
    LONG_POISON(27, ArrowParticleColors.POISON),
    STRONG_POISON(28, ArrowParticleColors.POISON),
    REGENERATION(29, ArrowParticleColors.REGENERATION),
    LONG_REGENERATION(30, ArrowParticleColors.REGENERATION),
    STRONG_REGENERATION(31, ArrowParticleColors.REGENERATION),
    STRENGTH(32, ArrowParticleColors.STRENGTH),
    LONG_STRENGTH(33, ArrowParticleColors.STRENGTH),
    STRONG_STRENGTH(34, ArrowParticleColors.STRENGTH),
    WEAKNESS(35, ArrowParticleColors.WEAKNESS),
    LONG_WEAKNESS(36, ArrowParticleColors.WEAKNESS),
    LUCK(2, ArrowParticleColors.NONE),
    TURTLE_MASTER(38, ArrowParticleColors.TURTLE_MASTER),
    LONG_TURTLE_MASTER(39, ArrowParticleColors.TURTLE_MASTER),
    STRONG_TURTLE_MASTER(40, ArrowParticleColors.TURTLE_MASTER),
    SLOW_FALLING(41, ArrowParticleColors.SLOW_FALLING),
    LONG_SLOW_FALLING(42, ArrowParticleColors.SLOW_FALLING);

    private static final TippedArrowPotion[] VALUES;
    private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ENGLISH);
    private final short bedrockId;
    private final int javaColor;

    private TippedArrowPotion(int bedrockId, ArrowParticleColors arrowParticleColor) {
        this.bedrockId = (short)bedrockId;
        this.javaColor = arrowParticleColor.getColor();
    }

    public static @Nullable TippedArrowPotion getByJavaIdentifier(String javaIdentifier) {
        for (TippedArrowPotion potion : VALUES) {
            if (!potion.javaIdentifier.equals(javaIdentifier)) continue;
            return potion;
        }
        return null;
    }

    public static @Nullable TippedArrowPotion getByBedrockId(int bedrockId) {
        for (TippedArrowPotion potion : VALUES) {
            if (potion.bedrockId != bedrockId) continue;
            return potion;
        }
        return null;
    }

    public static @Nullable TippedArrowPotion getByJavaColor(int color) {
        for (TippedArrowPotion potion : VALUES) {
            if (potion.javaColor != color) continue;
            return potion;
        }
        return null;
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    public short getBedrockId() {
        return this.bedrockId;
    }

    public int getJavaColor() {
        return this.javaColor;
    }

    static {
        VALUES = TippedArrowPotion.values();
    }

    private static enum ArrowParticleColors {
        NONE(-1),
        NIGHT_VISION(0x1F1FA1),
        INVISIBILITY(8356754),
        LEAPING(2293580),
        FIRE_RESISTANCE(14981690),
        SWIFTNESS(8171462),
        SLOWNESS(5926017),
        TURTLE_MASTER(7691106),
        WATER_BREATHING(3035801),
        HEALING(16262179),
        HARMING(4393481),
        POISON(5149489),
        REGENERATION(13458603),
        STRENGTH(9643043),
        WEAKNESS(0x484D48),
        LUCK(0x339900),
        SLOW_FALLING(16773073);

        private final int color;

        private ArrowParticleColors(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }
}

