/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

public class GeyserItemStack {
    public static final GeyserItemStack EMPTY = new GeyserItemStack(Items.AIR_ID, 0, null);
    private final int javaId;
    private int amount;
    private CompoundTag nbt;
    private int netId;
    private Item item;

    private GeyserItemStack(int javaId, int amount, CompoundTag nbt) {
        this(javaId, amount, nbt, 1);
    }

    private GeyserItemStack(int javaId, int amount, CompoundTag nbt, int netId) {
        this.javaId = javaId;
        this.amount = amount;
        this.nbt = nbt;
        this.netId = netId;
    }

    public static @NonNull GeyserItemStack from(@Nullable ItemStack itemStack) {
        return itemStack == null ? EMPTY : new GeyserItemStack(itemStack.getId(), itemStack.getAmount(), itemStack.getNbt());
    }

    public int getJavaId() {
        return this.isEmpty() ? 0 : this.javaId;
    }

    public int getAmount() {
        return this.isEmpty() ? 0 : this.amount;
    }

    public @Nullable CompoundTag getNbt() {
        return this.isEmpty() ? null : this.nbt;
    }

    public int getNetId() {
        return this.isEmpty() ? 0 : this.netId;
    }

    public void add(int add) {
        this.amount += add;
    }

    public void sub(int sub) {
        this.amount -= sub;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.amount);
    }

    public @Nullable ItemStack getItemStack(int newAmount) {
        return this.isEmpty() ? null : new ItemStack(this.javaId, newAmount, this.nbt);
    }

    public ItemData getItemData(GeyserSession session) {
        if (this.isEmpty()) {
            return ItemData.AIR;
        }
        ItemData.Builder itemData = ItemTranslator.translateToBedrock(session, this.javaId, this.amount, this.nbt);
        itemData.netId(this.getNetId());
        itemData.usingNetId(true);
        return itemData.build();
    }

    public ItemMapping getMapping(GeyserSession session) {
        return session.getItemMappings().getMapping(this.javaId);
    }

    public Item asItem() {
        if (this.item == null) {
            this.item = (Item)((List)Registries.JAVA_ITEMS.get()).get(this.javaId);
            return this.item;
        }
        return this.item;
    }

    public boolean isEmpty() {
        return this.amount <= 0 || this.javaId == Items.AIR_ID;
    }

    public GeyserItemStack copy() {
        return this.copy(this.amount);
    }

    public GeyserItemStack copy(int newAmount) {
        return this.isEmpty() ? EMPTY : new GeyserItemStack(this.javaId, newAmount, this.nbt == null ? null : this.nbt.clone(), this.netId);
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public void setNetId(int netId) {
        this.netId = netId;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserItemStack)) {
            return false;
        }
        GeyserItemStack other = (GeyserItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getJavaId() != other.getJavaId()) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.getNetId() != other.getNetId()) {
            return false;
        }
        CompoundTag this$nbt = this.getNbt();
        CompoundTag other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !((Object)this$nbt).equals(other$nbt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeyserItemStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getJavaId();
        result = result * 59 + this.getAmount();
        result = result * 59 + this.getNetId();
        CompoundTag $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public String toString() {
        return "GeyserItemStack(javaId=" + this.getJavaId() + ", amount=" + this.getAmount() + ", nbt=" + this.getNbt() + ", netId=" + this.getNetId() + ", item=" + this.item + ")";
    }
}

