/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundRenameItemPacket;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.ItemUtils;

public class AnvilContainer
extends Container {
    private int javaLevelCost = 0;
    private boolean useJavaLevelCost = false;
    private @Nullable String newName = null;
    private GeyserItemStack lastInput = GeyserItemStack.EMPTY;
    private GeyserItemStack lastMaterial = GeyserItemStack.EMPTY;
    private int lastTargetSlot = -1;

    public AnvilContainer(String title, int id, int size, ContainerType containerType, PlayerInventory playerInventory) {
        super(title, id, size, containerType, playerInventory);
    }

    public String checkForRename(GeyserSession session, String rename) {
        String correctRename;
        String plainNewName;
        this.newName = rename;
        String originalName = ItemUtils.getCustomName(this.getInput().getNbt());
        String plainOriginalName = MessageTranslator.convertToPlainTextLenient(originalName, session.locale());
        if (!plainOriginalName.equals(plainNewName = MessageTranslator.convertToPlainText(rename))) {
            correctRename = plainNewName;
            ServerboundRenameItemPacket renameItemPacket = new ServerboundRenameItemPacket(plainNewName);
            session.sendDownstreamGamePacket(renameItemPacket);
        } else {
            correctRename = MessageTranslator.convertMessageLenient(originalName);
            ServerboundRenameItemPacket renameItemPacket = new ServerboundRenameItemPacket(plainOriginalName);
            session.sendDownstreamGamePacket(renameItemPacket);
        }
        this.useJavaLevelCost = false;
        return correctRename;
    }

    public GeyserItemStack getInput() {
        return this.getItem(0);
    }

    public GeyserItemStack getMaterial() {
        return this.getItem(1);
    }

    public GeyserItemStack getResult() {
        return this.getItem(2);
    }

    public int getJavaLevelCost() {
        return this.javaLevelCost;
    }

    public boolean isUseJavaLevelCost() {
        return this.useJavaLevelCost;
    }

    public @Nullable String getNewName() {
        return this.newName;
    }

    public GeyserItemStack getLastInput() {
        return this.lastInput;
    }

    public GeyserItemStack getLastMaterial() {
        return this.lastMaterial;
    }

    public int getLastTargetSlot() {
        return this.lastTargetSlot;
    }

    public void setJavaLevelCost(int javaLevelCost) {
        this.javaLevelCost = javaLevelCost;
    }

    public void setUseJavaLevelCost(boolean useJavaLevelCost) {
        this.useJavaLevelCost = useJavaLevelCost;
    }

    public void setNewName(@Nullable String newName) {
        this.newName = newName;
    }

    public void setLastInput(GeyserItemStack lastInput) {
        this.lastInput = lastInput;
    }

    public void setLastMaterial(GeyserItemStack lastMaterial) {
        this.lastMaterial = lastMaterial;
    }

    public void setLastTargetSlot(int lastTargetSlot) {
        this.lastTargetSlot = lastTargetSlot;
    }
}

