/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.extension.ExtensionLoader;
import org.geysermc.geyser.api.extension.ExtensionManager;
import org.geysermc.geyser.extension.GeyserExtensionLoader;
import org.geysermc.geyser.text.GeyserLocale;

public class GeyserExtensionManager
extends ExtensionManager {
    private final GeyserExtensionLoader extensionLoader = new GeyserExtensionLoader();
    private final Map<String, Extension> extensions = new LinkedHashMap<String, Extension>();

    public void init() {
        GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.extensions.load.loading"));
        this.loadAllExtensions(this.extensionLoader);
        this.enableExtensions();
        GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.extensions.load.done", this.extensions.size()));
    }

    @Override
    public Extension extension(@NonNull String id) {
        return this.extensions.get(id);
    }

    @Override
    public void enable(@NonNull Extension extension) {
        if (!extension.isEnabled()) {
            try {
                this.enableExtension(extension);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.extensions.enable.failed", extension.name()), e);
                this.disable(extension);
            }
        }
    }

    @Override
    public void disable(@NonNull Extension extension) {
        if (extension.isEnabled()) {
            try {
                this.disableExtension(extension);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.extensions.disable.failed", extension.name()), e);
            }
        }
    }

    public void enableExtension(Extension extension) {
        if (!extension.isEnabled()) {
            extension.setEnabled(true);
            GeyserImpl.getInstance().eventBus().register(extension, extension);
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.extensions.enable.success", extension.name()));
        }
    }

    public void enableExtensions() {
        for (Extension extension : this.extensions()) {
            this.enable(extension);
        }
    }

    private void disableExtension(@NonNull Extension extension) {
        if (extension.isEnabled()) {
            GeyserImpl.getInstance().eventBus().unregisterAll(extension);
            extension.setEnabled(false);
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.extensions.disable.success", extension.name()));
        }
    }

    public void disableExtensions() {
        for (Extension extension : this.extensions()) {
            this.disable(extension);
        }
    }

    @Override
    public @NonNull Collection<Extension> extensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public @Nullable ExtensionLoader extensionLoader() {
        return this.extensionLoader;
    }

    @Override
    public void register(@NonNull Extension extension) {
        this.extensions.put(extension.description().id(), extension);
    }
}

