/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class CreeperEntity
extends MonsterEntity {
    private boolean ignitedByFlintAndSteel = false;

    public CreeperEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setSwelling(IntEntityMetadata entityMetadata) {
        if (!this.ignitedByFlintAndSteel) {
            this.setFlag(EntityFlag.IGNITED, entityMetadata.getPrimitiveValue() == 1);
        }
    }

    public void setIgnited(BooleanEntityMetadata entityMetadata) {
        this.ignitedByFlintAndSteel = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.IGNITED, this.ignitedByFlintAndSteel);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.session.getTagCache().isCreeperIgniter(itemInHand.asItem())) {
            return InteractiveTag.IGNITE_CREEPER;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.session.getTagCache().isCreeperIgniter(itemInHand.asItem())) {
            this.session.playSoundEvent(SoundEvent.IGNITE, this.position);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

