/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.DyeItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class WolfEntity
extends TameableEntity {
    private static final Set<Item> WOLF_FOODS = Set.of(Items.PUFFERFISH, Items.TROPICAL_FISH, Items.CHICKEN, Items.COOKED_CHICKEN, Items.PORKCHOP, Items.BEEF, Items.RABBIT, Items.COOKED_PORKCHOP, Items.COOKED_BEEF, Items.ROTTEN_FLESH, Items.MUTTON, Items.COOKED_MUTTON, Items.COOKED_RABBIT);
    private byte collarColor;

    public WolfEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void setTameableFlags(ByteEntityMetadata entityMetadata) {
        boolean angry;
        super.setTameableFlags(entityMetadata);
        byte xd = entityMetadata.getPrimitiveValue();
        boolean bl = angry = (xd & 2) == 2;
        if (angry) {
            this.dirtyMetadata.put(EntityDataTypes.COLOR, (byte)0);
        }
    }

    public void setCollarColor(IntEntityMetadata entityMetadata) {
        this.collarColor = (byte)entityMetadata.getPrimitiveValue();
        if (this.getFlag(EntityFlag.ANGRY)) {
            return;
        }
        this.dirtyMetadata.put(EntityDataTypes.COLOR, this.collarColor);
        if (this.ownerBedrockId == 0L) {
            this.dirtyMetadata.put(EntityDataTypes.OWNER_EID, this.session.getPlayerEntity().getGeyserId());
        }
    }

    public void setWolfAngerTime(IntEntityMetadata entityMetadata) {
        int time = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.ANGRY, time != 0);
        this.dirtyMetadata.put(EntityDataTypes.COLOR, time != 0 ? (byte)0 : this.collarColor);
    }

    @Override
    public boolean canEat(Item item) {
        return WOLF_FOODS.contains(item) && !this.isBaby();
    }

    @Override
    protected boolean canBeLeashed() {
        return !this.getFlag(EntityFlag.ANGRY) && super.canBeLeashed();
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.ANGRY)) {
            return InteractiveTag.NONE;
        }
        if (itemInHand.asItem() == Items.BONE && !this.getFlag(EntityFlag.TAMED)) {
            return InteractiveTag.TAME;
        }
        Item item = itemInHand.asItem();
        if (item instanceof DyeItem) {
            DyeItem item2 = (DyeItem)item;
            if (item2.dyeColor() != this.collarColor) {
                return InteractiveTag.DYE;
            }
        } else if (this.getFlag(EntityFlag.TAMED) && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId() || this.getFlag(EntityFlag.TAMED) || itemInHand.asItem() == Items.BONE && !this.getFlag(EntityFlag.ANGRY)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

