/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;

public class BeeEntity
extends AnimalEntity {
    public BeeEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setBeeFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        if ((xd & 2) == 2) {
            EntityEventPacket packet = new EntityEventPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.setType(EntityEventType.ATTACK_START);
            packet.setData(0);
            this.session.sendUpstreamPacket(packet);
        }
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, (xd & 4) == 4 ? 1 : 0);
        this.setFlag(EntityFlag.POWERED, (xd & 8) == 8);
    }

    public void setAngerTime(IntEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.ANGRY, entityMetadata.getPrimitiveValue() > 0);
    }

    @Override
    public boolean canEat(Item item) {
        return this.session.getTagCache().isFlower(item);
    }
}

