/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.util;

import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.util.impl.FormImageImpl;

public interface FormImage {
    public static @NonNull FormImage of(@NonNull Type type, @NonNull String data) {
        return new FormImageImpl(type, data);
    }

    public static @NonNull FormImage of(@NonNull String type, @NonNull String data) {
        Type imageType = Type.fromName(type);
        if (imageType == null) {
            throw new IllegalArgumentException("Received an unknown type '" + type + "'");
        }
        return FormImage.of(imageType, data);
    }

    public @NonNull Type type();

    public @NonNull String data();

    @Deprecated
    public Type getType();

    @Deprecated
    public String getData();

    public static enum Type {
        PATH,
        URL;

        private static final Type[] VALUES;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public static @Nullable Type fromName(@NonNull String name) {
            Objects.requireNonNull(name, "name");
            for (Type value : VALUES) {
                if (!value.typeName().equals(name)) continue;
                return value;
            }
            return null;
        }

        public @NonNull String typeName() {
            return this.name;
        }

        @Deprecated
        public static Type getByName(@NonNull String name) {
            return Type.fromName(name);
        }

        @Deprecated
        public String getName() {
            return this.name();
        }

        static {
            VALUES = Type.values();
        }
    }
}

