/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.definitions;

import java.util.TreeMap;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.common.NamedDefinition;

public class SimpleBlockDefinition
implements BlockDefinition,
NamedDefinition {
    private final String identifier;
    private final int runtimeId;
    private final NbtMap state;
    private transient String persistentIdentifier;

    public String getPersistentIdentifier() {
        if (this.persistentIdentifier == null) {
            StringBuilder builder = new StringBuilder(this.getIdentifier());
            if (!this.getState().isEmpty()) {
                TreeMap<String, String> properties = new TreeMap<String, String>();
                NbtMap states = this.getState().getCompound("states");
                for (String stateName : states.keySet()) {
                    String value = states.get(stateName).toString();
                    properties.put(stateName, value);
                }
                properties.forEach((name, state) -> builder.append("|").append((String)name).append("=").append((String)state));
            }
            this.persistentIdentifier = builder.toString();
        }
        return this.persistentIdentifier;
    }

    public SimpleBlockDefinition(String identifier, int runtimeId, NbtMap state) {
        this.identifier = identifier;
        this.runtimeId = runtimeId;
        this.state = state;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getRuntimeId() {
        return this.runtimeId;
    }

    public NbtMap getState() {
        return this.state;
    }

    public void setPersistentIdentifier(String persistentIdentifier) {
        this.persistentIdentifier = persistentIdentifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleBlockDefinition)) {
            return false;
        }
        SimpleBlockDefinition other = (SimpleBlockDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRuntimeId() != other.getRuntimeId()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        NbtMap this$state = this.getState();
        NbtMap other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)this$state).equals(other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleBlockDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRuntimeId();
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        NbtMap $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        return result;
    }

    public String toString() {
        return "SimpleBlockDefinition(identifier=" + this.getIdentifier() + ", runtimeId=" + this.getRuntimeId() + ", state=" + this.getState() + ", persistentIdentifier=" + this.getPersistentIdentifier() + ")";
    }
}

