/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.handler.codec.raknet.common;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.channel.raknet.packet.EncapsulatedPacket;

public class RakUnhandledMessagesQueue
extends SimpleChannelInboundHandler<EncapsulatedPacket> {
    public static final String NAME = "rak-unhandled-messages-queue";
    private final RakChannel channel;
    private final Queue<EncapsulatedPacket> messages = PlatformDependent.newMpscQueue();
    private ScheduledFuture<?> future;

    public RakUnhandledMessagesQueue(RakChannel channel) {
        this.channel = channel;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.future = ctx.channel().eventLoop().scheduleAtFixedRate(() -> this.trySendMessages(ctx), 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        EncapsulatedPacket message;
        if (this.future != null) {
            this.future.cancel(false);
        }
        while ((message = this.messages.poll()) != null) {
            ReferenceCountUtil.release((Object)((Object)message));
        }
    }

    private void trySendMessages(ChannelHandlerContext ctx) {
        EncapsulatedPacket message;
        if (!this.channel.isActive()) {
            return;
        }
        while ((message = this.messages.poll()) != null) {
            ctx.fireChannelRead((Object)message);
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    protected void channelRead0(ChannelHandlerContext ctx, EncapsulatedPacket msg) throws Exception {
        if (!this.channel.isActive()) {
            this.messages.offer(msg.retain());
            return;
        }
        this.trySendMessages(ctx);
        ctx.fireChannelRead((Object)msg.retain());
    }
}

