/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector3l;
import org.cloudburstmc.math.vector.Vector4l;
import org.cloudburstmc.math.vector.VectorNl;
import org.cloudburstmc.math.vector.Vectorl;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector2l
implements Vectorl,
Comparable<Vector2l>,
Serializable,
Cloneable {
    public static final Vector2l ZERO = Vector2l.from(0L, 0L);
    public static final Vector2l UNIT_X = Vector2l.from(1L, 0L);
    public static final Vector2l UNIT_Y = Vector2l.from(0L, 1L);
    public static final Vector2l ONE = Vector2l.from(1L, 1L);

    public abstract long getX();

    public abstract long getY();

    @Nonnull
    public Vector2l add(Vector2l v) {
        return this.add(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2l add(double x, double y) {
        return this.add(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public abstract Vector2l add(long var1, long var3);

    @Nonnull
    public Vector2l sub(Vector2l v) {
        return this.sub(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2l sub(double x, double y) {
        return this.sub(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public abstract Vector2l sub(long var1, long var3);

    @Nonnull
    public Vector2l mul(double a) {
        return this.mul(GenericMath.floor64(a));
    }

    @Override
    @Nonnull
    public Vector2l mul(long a) {
        return this.mul(a, a);
    }

    @Nonnull
    public Vector2l mul(Vector2l v) {
        return this.mul(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2l mul(double x, double y) {
        return this.mul(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public abstract Vector2l mul(long var1, long var3);

    @Nonnull
    public Vector2l div(double a) {
        return this.div(GenericMath.floor64(a));
    }

    @Override
    @Nonnull
    public Vector2l div(long a) {
        return this.div(a, a);
    }

    @Nonnull
    public Vector2l div(Vector2l v) {
        return this.div(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2l div(double x, double y) {
        return this.div(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public abstract Vector2l div(long var1, long var3);

    public long dot(Vector2l v) {
        return this.dot(v.getX(), v.getY());
    }

    public long dot(double x, double y) {
        return this.dot(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    public long dot(long x, long y) {
        return this.getX() * x + this.getY() * y;
    }

    @Nonnull
    public Vector2l project(Vector2l v) {
        return this.project(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2l project(double x, double y) {
        return this.project(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public abstract Vector2l project(long var1, long var3);

    @Nonnull
    public Vector2l pow(double pow) {
        return this.pow(GenericMath.floor64(pow));
    }

    @Override
    @Nonnull
    public abstract Vector2l pow(long var1);

    @Override
    @Nonnull
    public abstract Vector2l abs();

    @Override
    @Nonnull
    public abstract Vector2l negate();

    @Nonnull
    public Vector2l min(Vector2l v) {
        return this.min(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2l min(double x, double y) {
        return this.min(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public abstract Vector2l min(long var1, long var3);

    @Nonnull
    public Vector2l max(Vector2l v) {
        return this.max(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2l max(double x, double y) {
        return this.max(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public abstract Vector2l max(long var1, long var3);

    public long distanceSquared(Vector2l v) {
        return this.distanceSquared(v.getX(), v.getY());
    }

    public long distanceSquared(double x, double y) {
        return this.distanceSquared(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    public long distanceSquared(long x, long y) {
        long dx = this.getX() - x;
        long dy = this.getY() - y;
        return dx * dx + dy * dy;
    }

    public double distance(Vector2l v) {
        return this.distance(v.getX(), v.getY());
    }

    public double distance(double x, double y) {
        return this.distance(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    public double distance(long x, long y) {
        return Math.sqrt(this.distanceSquared(x, y));
    }

    @Nonnull
    public Vector2l north() {
        return this.north(1L);
    }

    @Nonnull
    public abstract Vector2l north(long var1);

    @Nonnull
    public Vector2l south() {
        return this.south(1L);
    }

    @Nonnull
    public abstract Vector2l south(long var1);

    @Nonnull
    public Vector2l east() {
        return this.east(1L);
    }

    @Nonnull
    public abstract Vector2l east(long var1);

    @Nonnull
    public Vector2l west() {
        return this.west(1L);
    }

    @Nonnull
    public abstract Vector2l west(long var1);

    @Override
    public long lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? 0 : 1;
    }

    @Override
    public int getMaxAxis() {
        return this.getX() > this.getY() ? 0 : 1;
    }

    @Nonnull
    public Vector3l toVector3() {
        return this.toVector3(0L);
    }

    @Nonnull
    public Vector3l toVector3(double z) {
        return this.toVector3(GenericMath.floor64(z));
    }

    @Nonnull
    public Vector3l toVector3(long z) {
        return Vector3l.from(this, z);
    }

    @Nonnull
    public Vector4l toVector4() {
        return this.toVector4(0L, 0L);
    }

    @Nonnull
    public Vector4l toVector4(double z, double w) {
        return this.toVector4(GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public Vector4l toVector4(long z, long w) {
        return Vector4l.from(this, z, w);
    }

    @Nonnull
    public VectorNl toVectorN() {
        return VectorNl.from(this);
    }

    @Override
    @Nonnull
    public long[] toArray() {
        return new long[]{this.getX(), this.getY()};
    }

    @Override
    @Nonnull
    public Vector2i toInt() {
        return Vector2i.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2l toLong() {
        return Vector2l.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2f toFloat() {
        return Vector2f.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2d toDouble() {
        return Vector2d.from(this.getX(), this.getY());
    }

    @Override
    public int compareTo(Vector2l v) {
        return (int)(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector2l clone() {
        return Vector2l.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ")";
    }

    @Nonnull
    public static Vector2l from(long n) {
        return Vectors.createVector2l(n, n);
    }

    @Nonnull
    public static Vector2l from(Vector2l v) {
        return Vector2l.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2l from(Vector3l v) {
        return Vector2l.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2l from(Vector4l v) {
        return Vector2l.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2l from(VectorNl v) {
        return Vector2l.from(v.get(0), v.get(1));
    }

    @Nonnull
    public static Vector2l from(double x, double y) {
        return Vector2l.from(GenericMath.floor64(x), GenericMath.floor64(y));
    }

    @Nonnull
    public static Vector2l from(long x, long y) {
        return Vectors.createVector2l(x, y);
    }
}

