/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector2l;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector4d;
import org.cloudburstmc.math.vector.VectorNd;
import org.cloudburstmc.math.vector.Vectord;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector2d
implements Vectord,
Comparable<Vector2d>,
Serializable,
Cloneable {
    public static final Vector2d ZERO = Vector2d.from(0.0f, 0.0f);
    public static final Vector2d UNIT_X = Vector2d.from(1.0f, 0.0f);
    public static final Vector2d UNIT_Y = Vector2d.from(0.0f, 1.0f);
    public static final Vector2d ONE = Vector2d.from(1.0f, 1.0f);

    public abstract double getX();

    public abstract double getY();

    public int getFloorX() {
        return GenericMath.floor(this.getX());
    }

    public int getFloorY() {
        return GenericMath.floor(this.getY());
    }

    @Nonnull
    public Vector2d add(Vector2d v) {
        return this.add(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d add(float x, float y) {
        return this.add((double)x, (double)y);
    }

    @Nonnull
    public abstract Vector2d add(double var1, double var3);

    @Nonnull
    public Vector2d sub(Vector2d v) {
        return this.sub(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d sub(float x, float y) {
        return this.sub((double)x, (double)y);
    }

    @Nonnull
    public abstract Vector2d sub(double var1, double var3);

    @Nonnull
    public Vector2d mul(float a) {
        return this.mul((double)a);
    }

    @Override
    @Nonnull
    public Vector2d mul(double a) {
        return this.mul(a, a);
    }

    @Nonnull
    public Vector2d mul(Vector2d v) {
        return this.mul(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d mul(float x, float y) {
        return this.mul((double)x, (double)y);
    }

    @Nonnull
    public abstract Vector2d mul(double var1, double var3);

    @Nonnull
    public Vector2d div(float a) {
        return this.div((double)a);
    }

    @Override
    @Nonnull
    public Vector2d div(double a) {
        return this.div(a, a);
    }

    @Nonnull
    public Vector2d div(Vector2d v) {
        return this.div(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d div(float x, float y) {
        return this.div((double)x, (double)y);
    }

    @Nonnull
    public abstract Vector2d div(double var1, double var3);

    public double dot(Vector2d v) {
        return this.dot(v.getX(), v.getY());
    }

    public double dot(float x, float y) {
        return this.dot((double)x, (double)y);
    }

    public double dot(double x, double y) {
        return this.getX() * x + this.getY() * y;
    }

    @Nonnull
    public Vector2d project(Vector2d v) {
        return this.project(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d project(float x, float y) {
        return this.project((double)x, (double)y);
    }

    @Nonnull
    public abstract Vector2d project(double var1, double var3);

    @Nonnull
    public Vector2d pow(float pow) {
        return this.pow((double)pow);
    }

    @Override
    @Nonnull
    public abstract Vector2d pow(double var1);

    @Override
    @Nonnull
    public abstract Vector2d ceil();

    @Override
    @Nonnull
    public abstract Vector2d floor();

    @Override
    @Nonnull
    public abstract Vector2d round();

    @Override
    @Nonnull
    public abstract Vector2d abs();

    @Override
    @Nonnull
    public abstract Vector2d negate();

    @Nonnull
    public Vector2d min(Vector2d v) {
        return this.min(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d min(float x, float y) {
        return this.min((double)x, (double)y);
    }

    @Nonnull
    public abstract Vector2d min(double var1, double var3);

    @Nonnull
    public Vector2d max(Vector2d v) {
        return this.max(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2d max(float x, float y) {
        return this.max((double)x, (double)y);
    }

    @Nonnull
    public abstract Vector2d max(double var1, double var3);

    public double distanceSquared(Vector2d v) {
        return this.distanceSquared(v.getX(), v.getY());
    }

    public double distanceSquared(float x, float y) {
        return this.distanceSquared((double)x, (double)y);
    }

    public double distanceSquared(double x, double y) {
        double dx = this.getX() - x;
        double dy = this.getY() - y;
        return dx * dx + dy * dy;
    }

    public double distance(Vector2d v) {
        return this.distance(v.getX(), v.getY());
    }

    public double distance(float x, float y) {
        return this.distance((double)x, (double)y);
    }

    public double distance(double x, double y) {
        return Math.sqrt(this.distanceSquared(x, y));
    }

    @Nonnull
    public Vector2d north() {
        return this.north(1.0);
    }

    @Nonnull
    public abstract Vector2d north(double var1);

    @Nonnull
    public Vector2d south() {
        return this.south(1.0);
    }

    @Nonnull
    public abstract Vector2d south(double var1);

    @Nonnull
    public Vector2d east() {
        return this.east(1.0);
    }

    @Nonnull
    public abstract Vector2d east(double var1);

    @Nonnull
    public Vector2d west() {
        return this.west(1.0);
    }

    @Nonnull
    public abstract Vector2d west(double var1);

    @Override
    public double lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Vector2d normalize();

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? 0 : 1;
    }

    @Override
    public int getMaxAxis() {
        return this.getX() > this.getY() ? 0 : 1;
    }

    @Nonnull
    public Vector3d toVector3() {
        return this.toVector3(0.0f);
    }

    @Nonnull
    public Vector3d toVector3(float z) {
        return this.toVector3((double)z);
    }

    @Nonnull
    public Vector3d toVector3(double z) {
        return Vector3d.from(this, z);
    }

    @Nonnull
    public Vector4d toVector4() {
        return this.toVector4(0.0f, 0.0f);
    }

    @Nonnull
    public Vector4d toVector4(float z, float w) {
        return this.toVector4((double)z, (double)w);
    }

    @Nonnull
    public Vector4d toVector4(double z, double w) {
        return Vector4d.from(this, z, w);
    }

    @Nonnull
    public VectorNd toVectorN() {
        return VectorNd.from(this);
    }

    @Override
    @Nonnull
    public double[] toArray() {
        return new double[]{this.getX(), this.getY()};
    }

    @Override
    @Nonnull
    public Vector2i toInt() {
        return Vector2i.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2l toLong() {
        return Vector2l.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2f toFloat() {
        return Vector2f.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2d toDouble() {
        return Vector2d.from(this.getX(), this.getY());
    }

    @Override
    public int compareTo(Vector2d v) {
        return (int)Math.signum(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector2d clone() {
        return Vector2d.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ")";
    }

    @Nonnull
    public static Vector2d from(double n) {
        return Vectors.createVector2d(n, n);
    }

    @Nonnull
    public static Vector2d from(Vector2d v) {
        return Vector2d.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2d from(Vector3d v) {
        return Vector2d.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2d from(Vector4d v) {
        return Vector2d.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2d from(VectorNd v) {
        return Vector2d.from(v.get(0), v.get(1));
    }

    @Nonnull
    public static Vector2d from(float x, float y) {
        return Vector2d.from((double)x, (double)y);
    }

    @Nonnull
    public static Vector2d from(double x, double y) {
        return Vectors.createVector2d(x, y);
    }

    @Nonnull
    public static Vector2d createRandomDirection(Random random) {
        return Vector2d.createDirectionRad(random.nextDouble() * (Math.PI * 2));
    }

    @Nonnull
    public static Vector2d createDirectionDeg(float angle) {
        return Vector2d.createDirectionDeg((double)angle);
    }

    @Nonnull
    public static Vector2d createDirectionDeg(double angle) {
        return Vector2d.createDirectionRad(Math.toRadians(angle));
    }

    @Nonnull
    public static Vector2d createDirectionRad(float angle) {
        return Vector2d.createDirectionRad((double)angle);
    }

    @Nonnull
    public static Vector2d createDirectionRad(double angle) {
        return Vector2d.from(TrigMath.cos(angle), TrigMath.sin(angle));
    }
}

