/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.vector.Vector2i;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector2i
extends Vector2i {
    private static final long serialVersionUID = 1L;
    private final int x;
    private final int y;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    @Nonnull
    public Vector2i add(int x, int y) {
        return Vector2i.from(this.x + x, this.y + y);
    }

    @Override
    @Nonnull
    public Vector2i sub(int x, int y) {
        return Vector2i.from(this.x - x, this.y - y);
    }

    @Override
    @Nonnull
    public Vector2i mul(int x, int y) {
        return Vector2i.from(this.x * x, this.y * y);
    }

    @Override
    @Nonnull
    public Vector2i div(int x, int y) {
        return Vector2i.from(this.x / x, this.y / y);
    }

    @Override
    @Nonnull
    public Vector2i project(int x, int y) {
        int lengthSquared = x * x + y * y;
        if (lengthSquared == 0) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        float a = (float)this.dot(x, y) / (float)lengthSquared;
        return Vector2i.from(a * (float)x, a * (float)y);
    }

    @Override
    @Nonnull
    public Vector2i pow(int power) {
        return Vector2i.from(Math.pow(this.x, power), Math.pow(this.y, power));
    }

    @Override
    @Nonnull
    public Vector2i abs() {
        return Vector2i.from(Math.abs(this.x), Math.abs(this.y));
    }

    @Override
    @Nonnull
    public Vector2i negate() {
        return Vector2i.from(-this.x, -this.y);
    }

    @Override
    @Nonnull
    public Vector2i min(int x, int y) {
        return Vector2i.from(Math.min(this.x, x), Math.min(this.y, y));
    }

    @Override
    @Nonnull
    public Vector2i max(int x, int y) {
        return Vector2i.from(Math.max(this.x, x), Math.max(this.y, y));
    }

    @Override
    @Nonnull
    public Vector2i north(int v) {
        return Vector2i.from(this.x, this.y - v);
    }

    @Override
    @Nonnull
    public Vector2i south(int v) {
        return Vector2i.from(this.x, this.y + v);
    }

    @Override
    @Nonnull
    public Vector2i east(int v) {
        return Vector2i.from(this.x + v, this.y);
    }

    @Override
    @Nonnull
    public Vector2i west(int v) {
        return Vector2i.from(this.x - v, this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector2i)) {
            return false;
        }
        Vector2i vector2 = (Vector2i)o;
        if (vector2.getX() != this.x) {
            return false;
        }
        return vector2.getY() == this.y;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = (float)this.x != 0.0f ? Integer.hashCode(this.x) : 0;
            this.hashCode = 31 * result + ((float)this.y != 0.0f ? Integer.hashCode(this.y) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

