/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.imaginary;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.imaginary.Quaternionf;

@ParametersAreNonnullByDefault
public class ImmutableQuaternionf
extends Quaternionf {
    private static final long serialVersionUID = 1L;
    private final float x;
    private final float y;
    private final float z;
    private final float w;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableQuaternionf(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public float getW() {
        return this.w;
    }

    @Override
    @Nonnull
    public Quaternionf add(float x, float y, float z, float w) {
        return Quaternionf.from(this.x + x, this.y + y, this.z + z, this.w + w);
    }

    @Override
    @Nonnull
    public Quaternionf sub(float x, float y, float z, float w) {
        return Quaternionf.from(this.x - x, this.y - y, this.z - z, this.w - w);
    }

    @Override
    @Nonnull
    public Quaternionf mul(float a) {
        return Quaternionf.from(this.x * a, this.y * a, this.z * a, this.w * a);
    }

    @Override
    @Nonnull
    public Quaternionf mul(float x, float y, float z, float w) {
        return Quaternionf.from(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y + this.y * w + this.z * x - this.x * z, this.w * z + this.z * w + this.x * y - this.y * x, this.w * w - this.x * x - this.y * y - this.z * z);
    }

    @Override
    @Nonnull
    public Quaternionf div(float a) {
        return Quaternionf.from(this.x / a, this.y / a, this.z / a, this.w / a);
    }

    @Override
    @Nonnull
    public Quaternionf div(float x, float y, float z, float w) {
        float d = x * x + y * y + z * z + w * w;
        return Quaternionf.from((this.x * w - this.w * x - this.z * y + this.y * z) / d, (this.y * w + this.z * x - this.w * y - this.x * z) / d, (this.z * w - this.y * x + this.x * y - this.w * z) / d, (this.w * w + this.x * x + this.y * y + this.z * z) / d);
    }

    @Override
    @Nonnull
    public Quaternionf conjugate() {
        return Quaternionf.from(-this.x, -this.y, -this.z, this.w);
    }

    @Override
    @Nonnull
    public Quaternionf invert() {
        float lengthSquared = this.lengthSquared();
        if (Math.abs(lengthSquared) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot invert a quaternion of length zero");
        }
        return this.conjugate().div(lengthSquared);
    }

    @Override
    @Nonnull
    public Quaternionf normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero quaternion");
        }
        return Quaternionf.from(this.x / length, this.y / length, this.z / length, this.w / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quaternionf)) {
            return false;
        }
        Quaternionf quaternion = (Quaternionf)o;
        if (Float.compare(quaternion.getW(), this.w) != 0) {
            return false;
        }
        if (Float.compare(quaternion.getX(), this.x) != 0) {
            return false;
        }
        if (Float.compare(quaternion.getY(), this.y) != 0) {
            return false;
        }
        return Float.compare(quaternion.getZ(), this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0f ? Float.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.hashCode(this.y) : 0);
            result = 31 * result + (this.z != 0.0f ? Float.hashCode(this.z) : 0);
            this.hashCode = 31 * result + (this.w != 0.0f ? Float.hashCode(this.w) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

