/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.blockstateupdater.util.tagupdater;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;

public class CompoundTagEditHelper {
    private final Deque<Object> parentTag = new ArrayDeque<Object>();
    private final Deque<String> tagName = new ArrayDeque<String>();
    private Map<String, Object> rootTag;
    private Object tag;

    public CompoundTagEditHelper(Map<String, Object> tag) {
        this.rootTag = tag;
        this.tag = tag;
    }

    public Map<String, Object> getRootTag() {
        return this.rootTag;
    }

    public Map<String, Object> getCompoundTag() {
        return (Map)this.tag;
    }

    public Object getTag() {
        return this.tag;
    }

    public Map<String, Object> getParent() {
        Object tag;
        if (!this.parentTag.isEmpty() && (tag = this.parentTag.peekLast()) instanceof Map) {
            return (Map)tag;
        }
        return null;
    }

    public boolean canPopChild() {
        return !this.parentTag.isEmpty();
    }

    public void popChild() {
        if (!this.parentTag.isEmpty()) {
            this.tag = this.parentTag.pollLast();
            this.tagName.pollLast();
        }
    }

    public void pushChild(String name) {
        Objects.requireNonNull(name, "name");
        if (!(this.tag instanceof Map)) {
            throw new IllegalStateException("Tag is not of Compound type");
        }
        this.parentTag.addLast(this.tag);
        this.tagName.addLast(name);
        this.tag = ((Map)this.tag).get(name);
    }

    public void replaceWith(String name, Object newTag) {
        this.tag = newTag;
        if (this.parentTag.isEmpty()) {
            this.rootTag = (Map)this.tag;
            return;
        }
        Object tag = this.parentTag.getLast();
        if (tag instanceof Map) {
            Map map = (Map)tag;
            map.remove(this.tagName.pollLast());
            map.put(name, newTag);
            this.tagName.offerLast(name);
        }
    }
}

