/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.blockstateupdater.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;

public class TagUtils {
    public static Object toMutable(Object immutable) {
        if (immutable instanceof NbtMap) {
            NbtMap map = (NbtMap)immutable;
            LinkedHashMap<String, Object> mutable = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                mutable.put(entry.getKey(), TagUtils.toMutable(entry.getValue()));
            }
            return mutable;
        }
        if (immutable instanceof NbtList) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object value : (List)immutable) {
                list.add(TagUtils.toMutable(value));
            }
            return list;
        }
        return immutable;
    }

    public static Object toImmutable(Object mutable) {
        if (mutable instanceof Map) {
            Map map = (Map)mutable;
            NbtMapBuilder immutable = NbtMap.builder();
            for (Map.Entry entry : map.entrySet()) {
                immutable.put((String)entry.getKey(), TagUtils.toImmutable(entry.getValue()));
            }
            return immutable.build();
        }
        if (mutable instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>();
            NbtType<Void> type = NbtType.END;
            for (Object value : (List)mutable) {
                if (type == NbtType.END) {
                    type = NbtType.byClass(value.getClass());
                }
                list.add(TagUtils.toImmutable(value));
            }
            return new NbtList<Void>(type, (Collection<Void>)list);
        }
        return mutable;
    }
}

