/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.blockstateupdater;

import org.cloudburstmc.blockstateupdater.BlockStateUpdater;
import org.cloudburstmc.blockstateupdater.util.OrderedUpdater;
import org.cloudburstmc.blockstateupdater.util.tagupdater.CompoundTagUpdaterContext;

public class BlockStateUpdater_1_20_30
implements BlockStateUpdater {
    public static final BlockStateUpdater INSTANCE = new BlockStateUpdater_1_20_30();
    public static final String[] COLORS = new String[]{"magenta", "pink", "green", "lime", "yellow", "black", "light_blue", "brown", "cyan", "orange", "red", "gray", "white", "blue", "purple", "silver"};

    @Override
    public void registerUpdaters(CompoundTagUpdaterContext ctx) {
        for (String color : COLORS) {
            if (color.equals("silver")) {
                this.addColorUpdater(ctx, "minecraft:stained_glass", color, "minecraft:light_gray_stained_glass");
                this.addColorUpdater(ctx, "minecraft:stained_glass_pane", color, "minecraft:light_gray_stained_glass_pane");
                this.addColorUpdater(ctx, "minecraft:concrete_powder", color, "minecraft:light_gray_concrete_powder");
                this.addColorUpdater(ctx, "minecraft:stained_hardened_clay", color, "minecraft:light_gray_terracotta");
                continue;
            }
            this.addColorUpdater(ctx, "minecraft:stained_glass", color, "minecraft:" + color + "_stained_glass");
            this.addColorUpdater(ctx, "minecraft:stained_glass_pane", color, "minecraft:" + color + "_stained_glass_pane");
            this.addColorUpdater(ctx, "minecraft:concrete_powder", color, "minecraft:" + color + "_concrete_powder");
            this.addColorUpdater(ctx, "minecraft:stained_hardened_clay", color, "minecraft:" + color + "_terracotta");
        }
        this.addDirectionUpdater(ctx, "minecraft:amethyst_cluster", OrderedUpdater.FACING_TO_BLOCK);
        this.addDirectionUpdater(ctx, "minecraft:medium_amethyst_bud", OrderedUpdater.FACING_TO_BLOCK);
        this.addDirectionUpdater(ctx, "minecraft:large_amethyst_bud", OrderedUpdater.FACING_TO_BLOCK);
        this.addDirectionUpdater(ctx, "minecraft:small_amethyst_bud", OrderedUpdater.FACING_TO_BLOCK);
        this.addDirectionUpdater(ctx, "minecraft:blast_furnace", OrderedUpdater.FACING_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:furnace", OrderedUpdater.FACING_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:lit_blast_furnace", OrderedUpdater.FACING_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:lit_furnace", OrderedUpdater.FACING_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:lit_smoker", OrderedUpdater.FACING_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:smoker", OrderedUpdater.FACING_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:anvil", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:big_dripleaf", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:calibrated_sculk_sensor", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:campfire", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:end_portal_frame", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:lectern", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:pink_petals", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:powered_comparator", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:powered_repeater", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:small_dripleaf_block", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:soul_campfire", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:unpowered_comparator", OrderedUpdater.DIRECTION_TO_CARDINAL);
        this.addDirectionUpdater(ctx, "minecraft:unpowered_repeater", OrderedUpdater.DIRECTION_TO_CARDINAL);
        ctx.addUpdater(1, 20, 30).regex("name", "minecraft:.+slab(?:[2-4])?\\b").visit("states").edit("top_slot_bit", helper -> {
            boolean value = helper.getTag() instanceof Byte ? (Byte)helper.getTag() == 1 : (Boolean)helper.getTag();
            if (value) {
                helper.replaceWith("minecraft:vertical_half", "top");
            } else {
                helper.replaceWith("minecraft:vertical_half", "bottom");
            }
        });
    }

    private void addColorUpdater(CompoundTagUpdaterContext context, String identifier, String color, String newIdentifier) {
        context.addUpdater(1, 20, 30).match("name", identifier).visit("states").match("color", color).edit("color", helper -> helper.getRootTag().put("name", newIdentifier)).remove("color");
    }

    private void addDirectionUpdater(CompoundTagUpdaterContext ctx, String identifier, OrderedUpdater updater) {
        ctx.addUpdater(1, 20, 30).match("name", identifier).visit("states").edit(updater.getOldProperty(), helper -> {
            int value = (Integer)helper.getTag();
            helper.replaceWith(updater.getNewProperty(), updater.translate(value));
        });
    }
}

