/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerState;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundPlayerCommandPacket
implements MinecraftPacket {
    private final int entityId;
    @NonNull
    private final PlayerState state;
    private final int jumpBoost;

    public ServerboundPlayerCommandPacket(int entityId, PlayerState state) {
        this(entityId, state, 0);
    }

    public ServerboundPlayerCommandPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        this.state = PlayerState.from(helper.readVarInt(in));
        this.jumpBoost = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        helper.writeVarInt(out, this.state.ordinal());
        helper.writeVarInt(out, this.jumpBoost);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public PlayerState getState() {
        return this.state;
    }

    public int getJumpBoost() {
        return this.jumpBoost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerCommandPacket)) {
            return false;
        }
        ServerboundPlayerCommandPacket other = (ServerboundPlayerCommandPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getJumpBoost() != other.getJumpBoost()) {
            return false;
        }
        PlayerState this$state = this.getState();
        PlayerState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundPlayerCommandPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getJumpBoost();
        PlayerState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundPlayerCommandPacket(entityId=" + this.getEntityId() + ", state=" + this.getState() + ", jumpBoost=" + this.getJumpBoost() + ")";
    }

    public ServerboundPlayerCommandPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerboundPlayerCommandPacket(entityId, this.state, this.jumpBoost);
    }

    public ServerboundPlayerCommandPacket withState(@NonNull PlayerState state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        return this.state == state ? this : new ServerboundPlayerCommandPacket(this.entityId, state, this.jumpBoost);
    }

    public ServerboundPlayerCommandPacket withJumpBoost(int jumpBoost) {
        return this.jumpBoost == jumpBoost ? this : new ServerboundPlayerCommandPacket(this.entityId, this.state, jumpBoost);
    }

    public ServerboundPlayerCommandPacket(int entityId, @NonNull PlayerState state, int jumpBoost) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.entityId = entityId;
        this.state = state;
        this.jumpBoost = jumpBoost;
    }
}

