/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.command.CommandNode;
import com.github.steveice10.mc.protocol.data.game.command.CommandParser;
import com.github.steveice10.mc.protocol.data.game.command.CommandType;
import com.github.steveice10.mc.protocol.data.game.command.properties.CommandProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.DoubleProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.EntityProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.FloatProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.IntegerProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.LongProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.ResourceProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.ScoreHolderProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.StringProperties;
import com.github.steveice10.mc.protocol.data.game.command.properties.TimeProperties;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.OptionalInt;
import lombok.NonNull;

public class ClientboundCommandsPacket
implements MinecraftPacket {
    private static final int FLAG_TYPE_MASK = 3;
    private static final int FLAG_EXECUTABLE = 4;
    private static final int FLAG_REDIRECT = 8;
    private static final int FLAG_SUGGESTION_TYPE = 16;
    private static final int NUMBER_FLAG_MIN_DEFINED = 1;
    private static final int NUMBER_FLAG_MAX_DEFINED = 2;
    private static final int ENTITY_FLAG_SINGLE_TARGET = 1;
    private static final int ENTITY_FLAG_PLAYERS_ONLY = 2;
    @NonNull
    private final CommandNode[] nodes;
    private final int firstNodeIndex;

    public ClientboundCommandsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.nodes = new CommandNode[helper.readVarInt(in)];
        for (int i = 0; i < this.nodes.length; ++i) {
            byte flags = in.readByte();
            CommandType type = CommandType.from(flags & 3);
            boolean executable = (flags & 4) != 0;
            int[] children = new int[helper.readVarInt(in)];
            for (int j = 0; j < children.length; ++j) {
                children[j] = helper.readVarInt(in);
            }
            OptionalInt redirectIndex = (flags & 8) != 0 ? OptionalInt.of(helper.readVarInt(in)) : OptionalInt.empty();
            String name = null;
            if (type == CommandType.LITERAL || type == CommandType.ARGUMENT) {
                name = helper.readString(in);
            }
            CommandParser parser = null;
            CommandProperties properties = null;
            String suggestionType = null;
            if (type == CommandType.ARGUMENT) {
                parser = CommandParser.from(helper.readVarInt(in));
                switch (parser) {
                    case DOUBLE: {
                        byte numberFlags = in.readByte();
                        double min = -1.7976931348623157E308;
                        double max = Double.MAX_VALUE;
                        if ((numberFlags & 1) != 0) {
                            min = in.readDouble();
                        }
                        if ((numberFlags & 2) != 0) {
                            max = in.readDouble();
                        }
                        properties = new DoubleProperties(min, max);
                        break;
                    }
                    case FLOAT: {
                        byte numberFlags = in.readByte();
                        float min = -3.4028235E38f;
                        float max = Float.MAX_VALUE;
                        if ((numberFlags & 1) != 0) {
                            min = in.readFloat();
                        }
                        if ((numberFlags & 2) != 0) {
                            max = in.readFloat();
                        }
                        properties = new FloatProperties(min, max);
                        break;
                    }
                    case INTEGER: {
                        byte numberFlags = in.readByte();
                        int min = Integer.MIN_VALUE;
                        int max = Integer.MAX_VALUE;
                        if ((numberFlags & 1) != 0) {
                            min = in.readInt();
                        }
                        if ((numberFlags & 2) != 0) {
                            max = in.readInt();
                        }
                        properties = new IntegerProperties(min, max);
                        break;
                    }
                    case LONG: {
                        byte numberFlags = in.readByte();
                        long min = Long.MIN_VALUE;
                        long max = Long.MAX_VALUE;
                        if ((numberFlags & 1) != 0) {
                            min = in.readLong();
                        }
                        if ((numberFlags & 2) != 0) {
                            max = in.readLong();
                        }
                        properties = new LongProperties(min, max);
                        break;
                    }
                    case STRING: {
                        properties = StringProperties.from(helper.readVarInt(in));
                        break;
                    }
                    case ENTITY: {
                        byte entityFlags = in.readByte();
                        properties = new EntityProperties((entityFlags & 1) != 0, (entityFlags & 2) != 0);
                        break;
                    }
                    case SCORE_HOLDER: {
                        properties = new ScoreHolderProperties(in.readBoolean());
                        break;
                    }
                    case TIME: {
                        properties = new TimeProperties(in.readInt());
                        break;
                    }
                    case RESOURCE_OR_TAG: 
                    case RESOURCE_OR_TAG_KEY: 
                    case RESOURCE: 
                    case RESOURCE_KEY: {
                        properties = new ResourceProperties(helper.readString(in));
                        break;
                    }
                }
                if ((flags & 0x10) != 0) {
                    suggestionType = helper.readResourceLocation(in);
                }
            }
            this.nodes[i] = new CommandNode(type, executable, children, redirectIndex, name, parser, properties, suggestionType);
        }
        this.firstNodeIndex = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.nodes.length);
        for (CommandNode node : this.nodes) {
            int flags = node.getType().ordinal() & 3;
            if (node.isExecutable()) {
                flags |= 4;
            }
            if (node.getRedirectIndex().isPresent()) {
                flags |= 8;
            }
            if (node.getSuggestionType() != null) {
                flags |= 0x10;
            }
            out.writeByte(flags);
            helper.writeVarInt(out, node.getChildIndices().length);
            for (int childIndex : node.getChildIndices()) {
                helper.writeVarInt(out, childIndex);
            }
            if (node.getRedirectIndex().isPresent()) {
                helper.writeVarInt(out, node.getRedirectIndex().getAsInt());
            }
            if (node.getType() == CommandType.LITERAL || node.getType() == CommandType.ARGUMENT) {
                helper.writeString(out, node.getName());
            }
            if (node.getType() != CommandType.ARGUMENT) continue;
            helper.writeVarInt(out, node.getParser().ordinal());
            switch (node.getParser()) {
                case DOUBLE: {
                    CommandProperties properties = (DoubleProperties)node.getProperties();
                    int numberFlags = 0;
                    if (((DoubleProperties)properties).getMin() != -1.7976931348623157E308) {
                        numberFlags |= 1;
                    }
                    if (((DoubleProperties)properties).getMax() != Double.MAX_VALUE) {
                        numberFlags |= 2;
                    }
                    out.writeByte(numberFlags);
                    if ((numberFlags & 1) != 0) {
                        out.writeDouble(((DoubleProperties)properties).getMin());
                    }
                    if ((numberFlags & 2) == 0) break;
                    out.writeDouble(((DoubleProperties)properties).getMax());
                    break;
                }
                case FLOAT: {
                    CommandProperties properties = (FloatProperties)node.getProperties();
                    int numberFlags = 0;
                    if (((FloatProperties)properties).getMin() != -3.4028235E38f) {
                        numberFlags |= 1;
                    }
                    if (((FloatProperties)properties).getMax() != Float.MAX_VALUE) {
                        numberFlags |= 2;
                    }
                    out.writeByte(numberFlags);
                    if ((numberFlags & 1) != 0) {
                        out.writeFloat(((FloatProperties)properties).getMin());
                    }
                    if ((numberFlags & 2) == 0) break;
                    out.writeFloat(((FloatProperties)properties).getMax());
                    break;
                }
                case INTEGER: {
                    CommandProperties properties = (IntegerProperties)node.getProperties();
                    int numberFlags = 0;
                    if (((IntegerProperties)properties).getMin() != Integer.MIN_VALUE) {
                        numberFlags |= 1;
                    }
                    if (((IntegerProperties)properties).getMax() != Integer.MAX_VALUE) {
                        numberFlags |= 2;
                    }
                    out.writeByte(numberFlags);
                    if ((numberFlags & 1) != 0) {
                        out.writeInt(((IntegerProperties)properties).getMin());
                    }
                    if ((numberFlags & 2) == 0) break;
                    out.writeInt(((IntegerProperties)properties).getMax());
                    break;
                }
                case LONG: {
                    CommandProperties properties = (LongProperties)node.getProperties();
                    int numberFlags = 0;
                    if (((LongProperties)properties).getMin() != Long.MIN_VALUE) {
                        numberFlags |= 1;
                    }
                    if (((LongProperties)properties).getMax() != Long.MAX_VALUE) {
                        numberFlags |= 2;
                    }
                    out.writeByte(numberFlags);
                    if ((numberFlags & 1) != 0) {
                        out.writeLong(((LongProperties)properties).getMin());
                    }
                    if ((numberFlags & 2) == 0) break;
                    out.writeLong(((LongProperties)properties).getMax());
                    break;
                }
                case STRING: {
                    helper.writeVarInt(out, ((StringProperties)node.getProperties()).ordinal());
                    break;
                }
                case ENTITY: {
                    CommandProperties properties = (EntityProperties)node.getProperties();
                    int entityFlags = 0;
                    if (((EntityProperties)properties).isSingleTarget()) {
                        entityFlags |= 1;
                    }
                    if (((EntityProperties)properties).isPlayersOnly()) {
                        entityFlags |= 2;
                    }
                    out.writeByte(entityFlags);
                    break;
                }
                case SCORE_HOLDER: {
                    out.writeBoolean(((ScoreHolderProperties)node.getProperties()).isAllowMultiple());
                    break;
                }
                case TIME: {
                    out.writeInt(((TimeProperties)node.getProperties()).getMin());
                    break;
                }
                case RESOURCE_OR_TAG: 
                case RESOURCE_OR_TAG_KEY: 
                case RESOURCE: 
                case RESOURCE_KEY: {
                    helper.writeString(out, ((ResourceProperties)node.getProperties()).getRegistryKey());
                    break;
                }
            }
            if (node.getSuggestionType() == null) continue;
            helper.writeResourceLocation(out, node.getSuggestionType());
        }
        helper.writeVarInt(out, this.firstNodeIndex);
    }

    @NonNull
    public CommandNode[] getNodes() {
        return this.nodes;
    }

    public int getFirstNodeIndex() {
        return this.firstNodeIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCommandsPacket)) {
            return false;
        }
        ClientboundCommandsPacket other = (ClientboundCommandsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFirstNodeIndex() != other.getFirstNodeIndex()) {
            return false;
        }
        return Arrays.deepEquals(this.getNodes(), other.getNodes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundCommandsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFirstNodeIndex();
        result = result * 59 + Arrays.deepHashCode(this.getNodes());
        return result;
    }

    public String toString() {
        return "ClientboundCommandsPacket(nodes=" + Arrays.deepToString(this.getNodes()) + ", firstNodeIndex=" + this.getFirstNodeIndex() + ")";
    }

    public ClientboundCommandsPacket withNodes(@NonNull CommandNode[] nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        return this.nodes == nodes ? this : new ClientboundCommandsPacket(nodes, this.firstNodeIndex);
    }

    public ClientboundCommandsPacket withFirstNodeIndex(int firstNodeIndex) {
        return this.firstNodeIndex == firstNodeIndex ? this : new ClientboundCommandsPacket(this.nodes, firstNodeIndex);
    }

    public ClientboundCommandsPacket(@NonNull CommandNode[] nodes, int firstNodeIndex) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        this.nodes = nodes;
        this.firstNodeIndex = firstNodeIndex;
    }
}

