/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.activation_range;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.function.Predicate;
import me.wesley1808.servercore.common.activation_range.ActivationType;
import me.wesley1808.servercore.common.config.tables.ActivationRangeConfig;
import me.wesley1808.servercore.common.interfaces.activation_range.LevelInfo;
import me.wesley1808.servercore.common.services.platform.PlatformHelper;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1420;
import net.minecraft.class_1421;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1480;
import net.minecraft.class_1501;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1538;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1621;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1672;
import net.minecraft.class_1685;
import net.minecraft.class_1690;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3763;
import net.minecraft.class_3855;
import net.minecraft.class_3857;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4466;
import net.minecraft.class_4760;

public class ActivationRange {
    private static final ReferenceOpenHashSet<class_1299<?>> EXCLUDED_ENTITY_TYPES = new ReferenceOpenHashSet();
    private static final Predicate<class_1352> BEE_GOAL_IMMUNITIES = goal -> goal instanceof class_4466.class_4473 || goal instanceof class_4466.class_4472;
    private static final class_4168[] VILLAGER_PANIC_IMMUNITIES = new class_4168[]{class_4168.field_19043, class_4168.field_19042, class_4168.field_19041, class_4168.field_18599};

    public static void reload() {
        EXCLUDED_ENTITY_TYPES.clear();
        for (String key : ActivationRangeConfig.EXCLUDED_ENTITY_TYPES.get()) {
            class_1299<?> type = PlatformHelper.getEntityType(key);
            if (type == null) continue;
            EXCLUDED_ENTITY_TYPES.add(type);
        }
    }

    public static ActivationType initializeEntityActivationType(class_1297 entity) {
        if (entity instanceof class_3763) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof class_1480) {
            return ActivationType.WATER;
        }
        if (entity instanceof class_1646) {
            return ActivationType.VILLAGER;
        }
        if (entity.method_5864() == class_1299.field_6051 || entity.method_5864() == class_1299.field_6071) {
            return ActivationType.ZOMBIE;
        }
        if (entity instanceof class_1548 || entity instanceof class_1621 || entity instanceof class_4760) {
            return ActivationType.MONSTER_BELOW;
        }
        if (entity instanceof class_1307) {
            return ActivationType.FLYING;
        }
        if (entity instanceof class_1569) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof class_1296 || entity instanceof class_1421) {
            return ActivationType.ANIMAL;
        }
        if (entity instanceof class_1314) {
            return ActivationType.NEUTRAL;
        }
        return ActivationType.MISC;
    }

    public static boolean isExcluded(class_1297 entity) {
        return entity.servercore$getActivationType().activationRange.getAsInt() <= 0 || entity.servercore$getActivationType().tickInterval.getAsInt() == 0 || entity instanceof class_1657 || entity instanceof class_3857 || entity instanceof class_1510 || entity instanceof class_1508 || entity instanceof class_1528 || entity instanceof class_3855 || entity instanceof class_1538 || entity instanceof class_1541 || entity instanceof class_1511 || entity instanceof class_1671 || entity instanceof class_1672 || entity instanceof class_1685 || EXCLUDED_ENTITY_TYPES.contains((Object)entity.method_5864());
    }

    public static void activateEntities(class_3218 level) {
        int currentTick = level.method_8503().method_3780();
        int maxRange = Integer.MIN_VALUE;
        for (ActivationType type : ActivationType.values()) {
            maxRange = Math.max(type.activationRange.getAsInt(), maxRange);
        }
        LevelInfo info = (LevelInfo)level;
        for (ActivationType.Wakeup wakeup : ActivationType.Wakeup.values()) {
            info.servercore$setRemaining(wakeup, Math.min(info.servercore$getRemaining(wakeup) + 1, wakeup.max.getAsInt()));
        }
        maxRange = Math.min((level.method_8503().method_3760().method_14568() << 4) - 8, maxRange);
        for (class_3222 player : level.method_18456()) {
            class_238 maxBB;
            if (player.method_7325()) continue;
            if (ActivationRangeConfig.USE_VERTICAL_RANGE.get().booleanValue()) {
                maxBB = player.method_5829().method_1009((double)maxRange, 128.0, (double)maxRange);
                for (ActivationType type : ActivationType.values()) {
                    type.boundingBox = player.method_5829().method_1014((double)type.activationRange.getAsInt());
                    if (type.extraHeightUp) {
                        type.boundingBox = type.boundingBox.method_1012(0.0, 96.0, 0.0);
                    }
                    if (!type.extraHeightDown) continue;
                    type.boundingBox = type.boundingBox.method_1012(0.0, -96.0, 0.0);
                }
            } else {
                maxBB = player.method_5829().method_1009((double)maxRange, 256.0, (double)maxRange);
                for (ActivationType type : ActivationType.values()) {
                    int range = type.activationRange.getAsInt();
                    type.boundingBox = player.method_5829().method_1009((double)range, 256.0, (double)range);
                }
            }
            for (class_1297 entity : level.method_8335((class_1297)player, maxBB)) {
                ActivationRange.activateEntity(entity, currentTick);
            }
        }
    }

    private static void activateEntity(class_1297 entity, int currentTick) {
        if (currentTick > entity.servercore$getActivatedTick() && (entity.servercore$isExcluded() || entity.servercore$getActivationType().boundingBox.method_994(entity.method_5829()))) {
            entity.servercore$setActivatedTick(currentTick + 19);
        }
    }

    public static int checkEntityImmunities(class_1297 entity, int currentTick) {
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity, currentTick);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.method_20802() > 0) {
            return 2;
        }
        if (entity.servercore$getActivatedImmunityTick() >= currentTick) {
            return 1;
        }
        if (!entity.method_5805()) {
            return 40;
        }
        ActivationType type = entity.servercore$getActivationType();
        if (entity.method_5799() && entity.method_5675() && type != ActivationType.ANIMAL && type != ActivationType.FLYING && type != ActivationType.VILLAGER && type != ActivationType.WATER && !(entity instanceof class_1690)) {
            return 100;
        }
        if (entity instanceof class_1542 || entity instanceof class_1303) {
            class_243 movement = entity.method_18798();
            if (movement.field_1352 != 0.0 || movement.field_1350 != 0.0 || movement.field_1351 > 0.0) {
                return 20;
            }
        }
        if (!(entity instanceof class_1665)) {
            if (!(entity.method_24828() || entity.method_5799() || entity instanceof class_1307 || entity instanceof class_1420)) {
                return 10;
            }
        } else {
            class_1665 projectile = (class_1665)entity;
            if (!projectile.field_7588) {
                return 1;
            }
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (living.field_6282 || !living.method_6026().isEmpty() || living.method_6101()) {
                return 1;
            }
            if (living instanceof class_1308) {
                class_1548 creeper;
                class_1501 llama;
                class_1308 mob = (class_1308)living;
                if (mob.method_5968() != null || mob.method_18868().method_18896(class_4140.field_22355)) {
                    return 20;
                }
                if (mob instanceof class_4466) {
                    class_4466 bee = (class_4466)mob;
                    if (bee.field_21079.method_23346() || bee.method_29511() || Util.hasTasks(bee.field_6201, BEE_GOAL_IMMUNITIES)) {
                        return 20;
                    }
                }
                if (mob instanceof class_1646) {
                    int immunityAfter;
                    class_1646 villager = (class_1646)mob;
                    class_4095 brain = villager.method_18868();
                    if (ActivationRangeConfig.VILLAGER_TICK_PANIC.get().booleanValue()) {
                        for (class_4168 activity : VILLAGER_PANIC_IMMUNITIES) {
                            if (!brain.method_18906(activity)) continue;
                            return 100;
                        }
                    }
                    if ((immunityAfter = ActivationRangeConfig.VILLAGER_WORK_IMMUNITY_AFTER.get().intValue()) > 0 && currentTick - mob.servercore$getActivatedTick() >= immunityAfter && brain.method_18906(class_4168.field_18596)) {
                        return ActivationRangeConfig.VILLAGER_WORK_IMMUNITY_FOR.get();
                    }
                }
                if (mob instanceof class_1501 && (llama = (class_1501)mob).method_6805()) {
                    return 1;
                }
                if (mob instanceof class_1429) {
                    class_1472 sheep;
                    class_1429 animal = (class_1429)mob;
                    if (animal.method_6109() || animal.method_6479()) {
                        return 5;
                    }
                    if (mob instanceof class_1472 && (sheep = (class_1472)mob).method_6629()) {
                        return 1;
                    }
                }
                if (mob instanceof class_1548 && (creeper = (class_1548)mob).method_7000()) {
                    return 20;
                }
                if (Util.hasTasks(mob.field_6185)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    public static boolean checkIfActive(class_1297 entity, int currentTick) {
        boolean active;
        if (ActivationRange.shouldTick(entity)) {
            return true;
        }
        boolean bl = active = entity.servercore$getActivatedTick() >= currentTick;
        if (!active) {
            int immunity;
            int inactiveTicks = currentTick - entity.servercore$getActivatedTick() - 1;
            if (inactiveTicks % 20 == 0 && (immunity = ActivationRange.checkEntityImmunities(entity, currentTick)) >= 0) {
                entity.servercore$setActivatedTick(currentTick + immunity);
                return true;
            }
            int tickInterval = entity.servercore$getActivationType().tickInterval.getAsInt();
            if (tickInterval > 0 && inactiveTicks % tickInterval == 0) {
                return true;
            }
        } else if (ActivationRangeConfig.SKIP_NON_IMMUNE.get().booleanValue() && entity.servercore$getFullTickCount() % 4 == 0 && ActivationRange.checkEntityImmunities(entity, currentTick) < 0) {
            return false;
        }
        return active;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldTick(class_1297 entity) {
        if (ActivationRangeConfig.ENABLED.get() == false) return true;
        if (entity.servercore$isExcluded()) return true;
        if (entity.field_5963) return true;
        if (entity.method_30230()) return true;
        if (entity.field_6012 < 200) {
            if (entity.servercore$getActivationType() == ActivationType.MISC) return true;
            if (ActivationRangeConfig.TICK_NEW_ENTITIES.get() != false) return true;
        }
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            if (mob.field_6202 instanceof class_1657) return true;
        }
        if (!(entity instanceof class_1309)) return false;
        class_1309 living = (class_1309)entity;
        if (living.field_6235 <= 0) return false;
        return true;
    }

    private static int checkInactiveWakeup(class_1297 entity, int currentTick) {
        LevelInfo info;
        int remaining;
        ActivationType.Wakeup wakeup = entity.servercore$getActivationType().wakeup;
        if (wakeup != null && (long)(currentTick - entity.servercore$getActivatedTick()) >= (long)wakeup.interval.getAsInt() * 20L && (remaining = (info = (LevelInfo)entity.method_37908()).servercore$getRemaining(wakeup)) > 0) {
            info.servercore$setRemaining(wakeup, remaining - 1);
            return 100;
        }
        return -1;
    }
}

