/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.internal;

import com.google.common.base.Preconditions;
import org.geysermc.floodgate.shadow.guice.Scope;
import org.geysermc.floodgate.shadow.guice.internal.AbstractProcessor;
import org.geysermc.floodgate.shadow.guice.internal.Annotations;
import org.geysermc.floodgate.shadow.guice.internal.Errors;
import org.geysermc.floodgate.shadow.guice.spi.ScopeBinding;

final class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding command) {
        ScopeBinding existing;
        Scope scope = (Scope)Preconditions.checkNotNull((Object)command.getScope(), (Object)"scope");
        Class annotationType = (Class)Preconditions.checkNotNull(command.getAnnotationType(), (Object)"annotation type");
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.missingScopeAnnotation(annotationType);
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.missingRuntimeRetention(annotationType);
        }
        if ((existing = this.injector.getBindingData().getScopeBinding(annotationType)) != null) {
            if (!scope.equals(existing.getScope())) {
                this.errors.duplicateScopes(existing, annotationType, scope);
            }
        } else {
            this.injector.getBindingData().putScopeBinding(annotationType, command);
        }
        return true;
    }
}

