/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.geysermc.floodgate.shadow.guice.Binder;
import org.geysermc.floodgate.shadow.guice.Key;
import org.geysermc.floodgate.shadow.guice.internal.BindingImpl;
import org.geysermc.floodgate.shadow.guice.internal.GuiceInternal;
import org.geysermc.floodgate.shadow.guice.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.guice.internal.InternalFactory;
import org.geysermc.floodgate.shadow.guice.internal.Scoping;
import org.geysermc.floodgate.shadow.guice.spi.BindingTargetVisitor;
import org.geysermc.floodgate.shadow.guice.spi.Dependency;
import org.geysermc.floodgate.shadow.guice.spi.Elements;
import org.geysermc.floodgate.shadow.guice.spi.HasDependencies;
import org.geysermc.floodgate.shadow.guice.spi.LinkedKeyBinding;

final class LinkedBindingImpl<T>
extends BindingImpl<T>
implements LinkedKeyBinding<T>,
HasDependencies {
    final Key<? extends T> targetKey;

    LinkedBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends T> targetKey) {
        super(injector, key, source, internalFactory, scoping);
        this.targetKey = targetKey;
    }

    LinkedBindingImpl(Object source, Key<T> key, Scoping scoping, Key<? extends T> targetKey) {
        super(source, key, scoping);
        this.targetKey = targetKey;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Key<? extends T> getLinkedKey() {
        return this.targetKey;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return ImmutableSet.of(Dependency.get(this.targetKey));
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new LinkedBindingImpl<T>(this.getSource(), this.getKey(), scoping, this.targetKey);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new LinkedBindingImpl<T>(this.getSource(), key, this.getScoping(), this.targetKey);
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(Elements.withTrustedSource(GuiceInternal.GUICE_INTERNAL, binder, this.getSource()).bind(this.getKey()).to(this.getLinkedKey()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(LinkedKeyBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", (Object)this.getScoping()).add("target", this.targetKey).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedBindingImpl) {
            LinkedBindingImpl o = (LinkedBindingImpl)obj;
            return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.targetKey, o.targetKey);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getScoping(), this.targetKey});
    }
}

