/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.internal;

import com.google.common.collect.ImmutableList;
import java.util.Set;
import java.util.stream.Stream;
import org.geysermc.floodgate.shadow.guice.internal.ConstructionProxyFactory;
import org.geysermc.floodgate.shadow.guice.internal.ConstructorInjector;
import org.geysermc.floodgate.shadow.guice.internal.DefaultConstructionProxyFactory;
import org.geysermc.floodgate.shadow.guice.internal.Errors;
import org.geysermc.floodgate.shadow.guice.internal.ErrorsException;
import org.geysermc.floodgate.shadow.guice.internal.FailableCache;
import org.geysermc.floodgate.shadow.guice.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.guice.internal.InternalFlags;
import org.geysermc.floodgate.shadow.guice.internal.MembersInjectorImpl;
import org.geysermc.floodgate.shadow.guice.internal.MethodAspect;
import org.geysermc.floodgate.shadow.guice.internal.ProxyFactory;
import org.geysermc.floodgate.shadow.guice.internal.SingleParameterInjector;
import org.geysermc.floodgate.shadow.guice.spi.InjectionPoint;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory factory = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList injectorAspects = this.injector.getBindingData().getMethodAspects();
            ImmutableList methodAspects = membersInjector.getAddedAspects().isEmpty() ? injectorAspects : (ImmutableList)Stream.concat(injectorAspects.stream(), membersInjector.getAddedAspects().stream()).collect(ImmutableList.toImmutableList());
            factory = new ProxyFactory(injectionPoint, (Iterable<MethodAspect>)methodAspects);
        } else {
            factory = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector((Set<InjectionPoint>)membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

