/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.internal;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.List;
import org.geysermc.floodgate.shadow.guice.Binder;
import org.geysermc.floodgate.shadow.guice.Key;
import org.geysermc.floodgate.shadow.guice.Scope;
import org.geysermc.floodgate.shadow.guice.internal.BindingImpl;
import org.geysermc.floodgate.shadow.guice.internal.Scoping;
import org.geysermc.floodgate.shadow.guice.internal.UntargettedBindingImpl;
import org.geysermc.floodgate.shadow.guice.spi.Element;
import org.geysermc.floodgate.shadow.guice.spi.InstanceBinding;

public abstract class AbstractBindingBuilder<T> {
    public static final String IMPLEMENTATION_ALREADY_SET = "Implementation is set more than once.";
    public static final String SINGLE_INSTANCE_AND_SCOPE = "Setting the scope is not permitted when binding to a single instance.";
    public static final String SCOPE_ALREADY_SET = "Scope is set more than once.";
    public static final String BINDING_TO_NULL = "Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.";
    public static final String CONSTANT_VALUE_ALREADY_SET = "Constant value is set more than once.";
    public static final String ANNOTATION_ALREADY_SPECIFIED = "More than one annotation is specified for this binding.";
    protected static final Key<?> NULL_KEY = Key.get(Void.class);
    protected final Binder binder;
    protected List<Element> elements;
    protected int position;
    private BindingImpl<T> binding;

    public AbstractBindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        this.binder = binder;
        this.elements = elements;
        this.position = elements.size();
        this.binding = new UntargettedBindingImpl<T>(source, key, Scoping.UNSCOPED);
        elements.add(this.position, this.binding);
    }

    protected BindingImpl<T> getBinding() {
        return this.binding;
    }

    protected BindingImpl<T> setBinding(BindingImpl<T> binding) {
        this.binding = binding;
        this.elements.set(this.position, binding);
        return binding;
    }

    protected BindingImpl<T> annotatedWithInternal(Class<? extends Annotation> annotationType) {
        Preconditions.checkNotNull(annotationType, (Object)"annotationType");
        this.checkNotAnnotated();
        return this.setBinding(this.binding.withKey(this.binding.getKey().withAnnotation(annotationType)));
    }

    protected BindingImpl<T> annotatedWithInternal(Annotation annotation) {
        Preconditions.checkNotNull((Object)annotation, (Object)"annotation");
        this.checkNotAnnotated();
        return this.setBinding(this.binding.withKey(this.binding.getKey().withAnnotation(annotation)));
    }

    public void in(Class<? extends Annotation> scopeAnnotation) {
        Preconditions.checkNotNull(scopeAnnotation, (Object)"scopeAnnotation");
        this.checkNotScoped();
        this.setBinding(this.getBinding().withScoping(Scoping.forAnnotation(scopeAnnotation)));
    }

    public void in(Scope scope) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope");
        this.checkNotScoped();
        this.setBinding(this.getBinding().withScoping(Scoping.forInstance(scope)));
    }

    public void asEagerSingleton() {
        this.checkNotScoped();
        this.setBinding(this.getBinding().withScoping(Scoping.EAGER_SINGLETON));
    }

    protected boolean keyTypeIsSet() {
        return !Void.class.equals((Object)this.binding.getKey().getTypeLiteral().getType());
    }

    protected void checkNotTargetted() {
        if (!(this.binding instanceof UntargettedBindingImpl)) {
            this.binder.addError(IMPLEMENTATION_ALREADY_SET, new Object[0]);
        }
    }

    protected void checkNotAnnotated() {
        if (this.binding.getKey().getAnnotationType() != null) {
            this.binder.addError(ANNOTATION_ALREADY_SPECIFIED, new Object[0]);
        }
    }

    protected void checkNotScoped() {
        if (this.binding instanceof InstanceBinding) {
            this.binder.addError(SINGLE_INSTANCE_AND_SCOPE, new Object[0]);
            return;
        }
        if (this.binding.getScoping().isExplicitlyScoped()) {
            this.binder.addError(SCOPE_ALREADY_SET, new Object[0]);
        }
    }
}

