/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.config;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.util.UUID;
import org.geysermc.configutils.ConfigUtilities;
import org.geysermc.configutils.file.codec.PathFileCodec;
import org.geysermc.configutils.file.template.ResourceTemplateReader;
import org.geysermc.configutils.updater.change.Changes;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.crypto.KeyProducer;

public final class ConfigLoader {
    private final Path dataFolder;
    private final Class<? extends FloodgateConfig> configClass;
    private final KeyProducer keyProducer;
    private final FloodgateCipher cipher;
    private final FloodgateLogger logger;

    public <T extends FloodgateConfig> T load() {
        String templateFile = "config.yml";
        if (ProxyFloodgateConfig.class.isAssignableFrom(this.configClass)) {
            templateFile = "proxy-" + templateFile;
        }
        ConfigUtilities utilities = ConfigUtilities.builder().fileCodec(PathFileCodec.of(this.dataFolder)).configFile("config.yml").templateReader(ResourceTemplateReader.of(this.getClass())).template(templateFile).changes(Changes.builder().version(1, Changes.versionBuilder().keyRenamed("player-link.enable", "player-link.enabled").keyRenamed("player-link.allow-linking", "player-link.allowed")).version(2, Changes.versionBuilder().keyRenamed("player-link.use-global-linking", "player-link.enable-global-linking")).build()).definePlaceholder("metrics.uuid", UUID::randomUUID).postInitializeCallbackArgument(this).build();
        try {
            return (T)utilities.executeOn(this.configClass);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to load the config! Try to delete the config file if this error persists", throwable);
        }
    }

    public void generateKey(Path keyPath) {
        try {
            Key key = this.keyProducer.produce();
            this.cipher.init(key);
            String test = "abcdefghijklmnopqrstuvwxyz0123456789";
            byte[] encrypted = this.cipher.encryptFromString(test);
            String decrypted = this.cipher.decryptToString(encrypted);
            if (!test.equals(decrypted)) {
                this.logger.error("Whoops, we tested the generated Floodgate keys but the decrypted test message doesn't match the original.\nOriginal message: " + test + ".Decrypted message: " + decrypted + ".\nThe encrypted message itself: " + new String(encrypted), new Object[0]);
                throw new RuntimeException("Tested the generated public and private key but, the decrypted message doesn't match the original!");
            }
            Files.write(keyPath, key.getEncoded(), new OpenOption[0]);
        }
        catch (Exception exception) {
            this.logger.error("Error while creating key", exception, new Object[0]);
        }
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }

    public Class<? extends FloodgateConfig> getConfigClass() {
        return this.configClass;
    }

    public KeyProducer getKeyProducer() {
        return this.keyProducer;
    }

    public FloodgateCipher getCipher() {
        return this.cipher;
    }

    public FloodgateLogger getLogger() {
        return this.logger;
    }

    public ConfigLoader(Path dataFolder, Class<? extends FloodgateConfig> configClass, KeyProducer keyProducer, FloodgateCipher cipher, FloodgateLogger logger) {
        this.dataFolder = dataFolder;
        this.configClass = configClass;
        this.keyProducer = keyProducer;
        this.cipher = cipher;
        this.logger = logger;
    }
}

