/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.geysermc.floodgate.FabricPlatform;
import org.geysermc.floodgate.MinecraftServerHolder;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.fabric.FabricInjector;
import org.geysermc.floodgate.module.FabricAddonModule;
import org.geysermc.floodgate.module.FabricCommandModule;
import org.geysermc.floodgate.module.FabricListenerModule;
import org.geysermc.floodgate.module.FabricPlatformModule;
import org.geysermc.floodgate.module.PluginMessageModule;
import org.geysermc.floodgate.module.ServerCommonModule;
import org.geysermc.floodgate.shadow.guice.Guice;
import org.geysermc.floodgate.shadow.guice.Injector;

public class FabricMod
implements ModInitializer {
    public void onInitialize() {
        FabricInjector.setInstance(new FabricInjector());
        Injector injector = Guice.createInjector(new ServerCommonModule(FabricLoader.getInstance().getConfigDir().resolve("floodgate")), new FabricPlatformModule());
        FabricPlatform platform = injector.getInstance(FabricPlatform.class);
        platform.enable(new FabricCommandModule());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            long ctm = System.currentTimeMillis();
            MinecraftServerHolder.set(server);
            platform.enable(new FabricAddonModule(), new FabricListenerModule(), new PluginMessageModule());
            long endCtm = System.currentTimeMillis();
            injector.getInstance(FloodgateLogger.class).translatedInfo("floodgate.core.finish", endCtm - ctm);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> platform.disable());
    }
}

