/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v2.impl.autogen;

import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.config.v2.api.ConfigField;
import dev.isxander.yacl3.config.v2.api.autogen.ListGroup;
import dev.isxander.yacl3.config.v2.api.autogen.OptionAccess;
import dev.isxander.yacl3.config.v2.api.autogen.OptionFactory;
import dev.isxander.yacl3.config.v2.impl.FieldBackedBinding;
import dev.isxander.yacl3.config.v2.impl.autogen.YACLAutoGenException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ListGroupImpl<T>
implements OptionFactory<ListGroup, List<T>> {
    @Override
    public Option<List<T>> createOption(ListGroup annotation, ConfigField<List<T>> field, OptionAccess optionAccess) {
        if (field.autoGen().orElseThrow().group().isPresent()) {
            throw new YACLAutoGenException("@ListGroup fields ('%s') cannot be inside a group as lists act as groups.".formatted(field.access().name()));
        }
        ListGroup.ValueFactory<T> valueFactory = this.createValueFactory(annotation.valueFactory());
        ListGroup.ControllerFactory controllerFactory = this.createControllerFactory(annotation.controllerFactory());
        return ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)this.getTranslationKey(field, null))).description(this.description(field)).initial(valueFactory::provideNewValue).controller(opt -> controllerFactory.createController(annotation, field, optionAccess, (Option)opt)).binding(new FieldBackedBinding<List<T>>(field.access(), field.defaultAccess())).minimumNumberOfEntries(annotation.minEntries()).maximumNumberOfEntries(annotation.maxEntries() == 0 ? Integer.MAX_VALUE : annotation.maxEntries()).insertEntriesAtEnd(annotation.addEntriesToBottom()).build();
    }

    private OptionDescription description(ConfigField<List<T>> field) {
        OptionDescription.Builder builder = OptionDescription.createBuilder();
        Object key = this.getTranslationKey(field, "desc");
        if (class_2477.method_10517().method_4678((String)key)) {
            builder.text(new class_2561[]{class_2561.method_43471((String)key)});
        } else {
            key = (String)key + ".";
            int i = 0;
            while (class_2477.method_10517().method_4678((String)key + i++)) {
                builder.text(new class_2561[]{class_2561.method_43471((String)((String)key + i))});
            }
        }
        Object imagePath = "textures/yacl3/" + field.parent().id().method_12832() + "/" + field.access().name() + ".webp";
        imagePath = ((String)imagePath).toLowerCase().replaceAll("[^a-z0-9/._:-]", "_");
        class_2960 imageLocation = new class_2960(field.parent().id().method_12836(), (String)imagePath);
        if (class_310.method_1551().method_1478().method_14486(imageLocation).isPresent()) {
            builder.webpImage(imageLocation);
        }
        return builder.build();
    }

    private ListGroup.ValueFactory<T> createValueFactory(Class<? extends ListGroup.ValueFactory<T>> clazz) {
        Constructor<ListGroup.ValueFactory<T>> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new YACLAutoGenException("Could not find no-args constructor for `valueFactory` on '%s' for @ListGroup field.".formatted(clazz.getName()), e);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new YACLAutoGenException("Couldn't invoke no-args constructor for `valueFactory` on '%s' for @ListGroup field.".formatted(clazz.getName()), e);
        }
    }

    private ListGroup.ControllerFactory<T> createControllerFactory(Class<? extends ListGroup.ControllerFactory<T>> clazz) {
        Constructor<ListGroup.ControllerFactory<T>> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new YACLAutoGenException("Could not find no-args constructor on `controllerFactory`, '%s' for @ListGroup field.".formatted(clazz.getName()), e);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new YACLAutoGenException("Couldn't invoke no-args constructor on `controllerFactory`, '%s' for @ListGroup field.".formatted(clazz.getName()), e);
        }
    }

    private String getTranslationKey(ConfigField<List<T>> field, @Nullable String suffix) {
        Object key = "yacl3.config.%s.%s".formatted(field.parent().id().toString(), field.access().name());
        if (suffix != null) {
            key = (String)key + "." + suffix;
        }
        return key;
    }
}

