/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import xaero.common.AXaeroMinimap;
import xaero.common.server.IMinecraftServer;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.server.level.LevelMapPropertiesIO;
import xaero.common.server.radar.tracker.SyncedPlayerTracker;
import xaero.common.server.radar.tracker.SyncedPlayerTrackerSystemManager;

public class MinecraftServerData {
    private final SyncedPlayerTrackerSystemManager syncedPlayerTrackerSystemManager;
    private final SyncedPlayerTracker syncedPlayerTracker;
    private final Map<Path, LevelMapProperties> levelProperties;
    private final LevelMapPropertiesIO propertiesIO;
    private final AXaeroMinimap modMain;

    public MinecraftServerData(SyncedPlayerTrackerSystemManager syncedPlayerTrackerSystemManager, SyncedPlayerTracker syncedPlayerTracker, AXaeroMinimap modMain) {
        this.syncedPlayerTrackerSystemManager = syncedPlayerTrackerSystemManager;
        this.syncedPlayerTracker = syncedPlayerTracker;
        this.levelProperties = new HashMap<Path, LevelMapProperties>();
        this.propertiesIO = new LevelMapPropertiesIO();
        this.modMain = modMain;
    }

    public LevelMapProperties getLevelProperties(Path path) {
        LevelMapProperties properties = this.levelProperties.get(path);
        if (properties == null) {
            properties = new LevelMapProperties();
            try {
                this.propertiesIO.load(path, properties);
            }
            catch (FileNotFoundException fnfe) {
                this.propertiesIO.save(path, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.levelProperties.put(path, properties);
        }
        return properties;
    }

    public SyncedPlayerTrackerSystemManager getSyncedPlayerTrackerSystemManager() {
        return this.syncedPlayerTrackerSystemManager;
    }

    public SyncedPlayerTracker getSyncedPlayerTracker() {
        return this.syncedPlayerTracker;
    }

    public static MinecraftServerData get(MinecraftServer server) {
        return ((IMinecraftServer)server).getXaeroMinimapServerData();
    }

    public AXaeroMinimap getModMain() {
        return this.modMain;
    }
}

