/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern NON_UNIQUE_PREFIX = Pattern.compile("^[a-zA-Z0-9_]{0,16}$");
    private static final Pattern DATABASE_NAME = Pattern.compile("^floodgate-[a-zA-Z0-9_]{0,16}-database.jar$");

    public static void removeHandler(ChannelPipeline pipeline, String handler) {
        ChannelHandler channelHandler = pipeline.get(handler);
        if (channelHandler != null) {
            pipeline.remove(channelHandler);
        }
    }

    public static List<String> readAllLines(String resourcePath) throws IOException {
        InputStream stream = Utils.class.getClassLoader().getResourceAsStream(resourcePath);
        try (BufferedReader reader = Utils.newBufferedReader(stream, StandardCharsets.UTF_8);){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public static BufferedReader newBufferedReader(InputStream inputStream, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        InputStreamReader reader = new InputStreamReader(inputStream, decoder);
        return new BufferedReader(reader);
    }

    public static Properties readProperties(String resourceFile) {
        Properties properties = new Properties();
        try (InputStream is = Utils.class.getClassLoader().getResourceAsStream(resourceFile);){
            properties.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getLocale(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    public static UUID getJavaUuid(long xuid) {
        return new UUID(0L, xuid);
    }

    public static UUID getJavaUuid(String xuid) {
        return Utils.getJavaUuid(Long.parseLong(xuid));
    }

    public static boolean isUniquePrefix(String prefix) {
        return !NON_UNIQUE_PREFIX.matcher(prefix).matches();
    }

    public static boolean isValidDatabaseName(String databaseName) {
        return DATABASE_NAME.matcher(databaseName).matches();
    }

    public static int readVarInt(ByteBuf buffer) {
        byte current;
        int out = 0;
        int count = 0;
        do {
            current = buffer.readByte();
            out |= (current & 0x7F) << count++ * 7;
            if (count <= 5) continue;
            throw new RuntimeException("VarInt is bigger then allowed");
        } while ((current & 0x80) != 0);
        return out;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }
}

