/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.guice.internal;

import com.google.common.collect.Lists;
import java.util.List;
import org.geysermc.floodgate.shadow.guice.Key;
import org.geysermc.floodgate.shadow.guice.MembersInjector;
import org.geysermc.floodgate.shadow.guice.Provider;
import org.geysermc.floodgate.shadow.guice.TypeLiteral;
import org.geysermc.floodgate.shadow.guice.internal.Errors;
import org.geysermc.floodgate.shadow.guice.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.guice.internal.LookupProcessor;
import org.geysermc.floodgate.shadow.guice.internal.Lookups;
import org.geysermc.floodgate.shadow.guice.spi.Element;
import org.geysermc.floodgate.shadow.guice.spi.MembersInjectorLookup;
import org.geysermc.floodgate.shadow.guice.spi.ProviderLookup;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

