/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage;

import java.util.UUID;

public interface PluginMessageChannel {
    public String getIdentifier();

    public Result handleProxyCall(byte[] var1, UUID var2, String var3, Identity var4, UUID var5, String var6, Identity var7);

    public Result handleServerCall(byte[] var1, UUID var2, String var3);

    public static enum Identity {
        UNKNOWN,
        SERVER,
        PLAYER;

    }

    public static final class Result {
        private static final Result FORWARD = new Result(true, null);
        private static final Result HANDLED = new Result(false, null);
        private final boolean allowed;
        private final String reason;

        public static Result forward() {
            return FORWARD;
        }

        public static Result handled() {
            return HANDLED;
        }

        public static Result kick(String reason) {
            return new Result(false, reason);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public String getReason() {
            return this.reason;
        }

        private Result(boolean allowed, String reason) {
            this.allowed = allowed;
            this.reason = reason;
        }
    }
}

