/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import org.apache.logging.log4j.LogManager;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.fabric.FabricInjector;
import org.geysermc.floodgate.listener.FabricEventListener;
import org.geysermc.floodgate.listener.FabricEventRegistration;
import org.geysermc.floodgate.logger.Log4jFloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.listener.ListenerRegistration;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.platform.util.PlatformUtils;
import org.geysermc.floodgate.pluginmessage.FabricPluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.FabricPluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.FabricSkinApplier;
import org.geysermc.floodgate.pluginmessage.PluginMessageRegistration;
import org.geysermc.floodgate.shadow.guice.AbstractModule;
import org.geysermc.floodgate.shadow.guice.Provides;
import org.geysermc.floodgate.shadow.guice.Singleton;
import org.geysermc.floodgate.shadow.guice.name.Named;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.FabricCommandUtil;
import org.geysermc.floodgate.util.FabricPlatformUtils;
import org.geysermc.floodgate.util.LanguageManager;

public final class FabricPlatformModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(PlatformUtils.class).to(FabricPlatformUtils.class);
    }

    @Provides
    @Singleton
    public FloodgateLogger floodgateLogger(LanguageManager languageManager) {
        return new Log4jFloodgateLogger(LogManager.getLogger((String)"floodgate"), languageManager);
    }

    @Provides
    @Singleton
    public CommandUtil commandUtil(FloodgateApi api, FloodgateLogger logger, LanguageManager languageManager) {
        return new FabricCommandUtil(languageManager, api, logger);
    }

    @Provides
    @Singleton
    public ListenerRegistration<FabricEventListener> listenerRegistration() {
        return new FabricEventRegistration();
    }

    @Provides
    @Singleton
    public CommonPlatformInjector platformInjector() {
        return FabricInjector.getInstance();
    }

    @Provides
    @Named(value="packetEncoder")
    public String packetEncoder() {
        return "encoder";
    }

    @Provides
    @Named(value="packetDecoder")
    public String packetDecoder() {
        return "decoder";
    }

    @Provides
    @Named(value="packetHandler")
    public String packetHandler() {
        return "packet_handler";
    }

    @Provides
    @Singleton
    public PluginMessageUtils pluginMessageUtils() {
        return new FabricPluginMessageUtils();
    }

    @Provides
    @Named(value="implementationName")
    public String implementationName() {
        return "Fabric";
    }

    @Provides
    @Singleton
    public PluginMessageRegistration pluginMessageRegister() {
        return new FabricPluginMessageRegistration();
    }

    @Provides
    @Singleton
    public SkinApplier skinApplier() {
        return new FabricSkinApplier();
    }
}

