/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.logger;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.MessageFormatter;

public final class Log4jFloodgateLogger
implements FloodgateLogger {
    private final Logger logger;
    private final LanguageManager languageManager;

    @Override
    public void error(String message, Object ... args) {
        this.logger.error(message, args);
    }

    @Override
    public void error(String message, Throwable throwable, Object ... args) {
        this.logger.error(MessageFormatter.format(message, args), throwable);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.logger.warn(message, args);
    }

    @Override
    public void info(String message, Object ... args) {
        this.logger.info(message, args);
    }

    @Override
    public void translatedInfo(String message, Object ... args) {
        this.logger.info(this.languageManager.getLogString(message, args));
    }

    @Override
    public void debug(String message, Object ... args) {
        this.logger.debug(message, args);
    }

    @Override
    public void trace(String message, Object ... args) {
        this.logger.trace(message, args);
    }

    @Override
    public void enableDebug() {
        if (!this.logger.isDebugEnabled()) {
            Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        }
    }

    @Override
    public void disableDebug() {
        if (this.logger.isDebugEnabled()) {
            Configurator.setLevel((String)this.logger.getName(), (Level)Level.INFO);
        }
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    public Log4jFloodgateLogger(Logger logger, LanguageManager languageManager) {
        this.logger = logger;
        this.languageManager = languageManager;
    }
}

