/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.command.main;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.context.CommandContext;
import java.util.Locale;
import java.util.function.Consumer;
import org.geysermc.floodgate.command.main.FirewallCheckSubcommand;
import org.geysermc.floodgate.command.util.Permission;
import org.geysermc.floodgate.platform.command.FloodgateCommand;
import org.geysermc.floodgate.player.UserAudience;

public final class MainCommand
implements FloodgateCommand {
    @Override
    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        Command.Builder builder = commandManager.commandBuilder("floodgate", ArgumentDescription.of((String)"A set of Floodgate related actions in one command"), new String[0]).senderType(UserAudience.class).permission(Permission.COMMAND_MAIN.get()).handler(this::execute);
        for (SubCommand subCommand : SubCommand.VALUES) {
            commandManager.command(builder.literal(subCommand.name().toLowerCase(Locale.ROOT), new String[]{subCommand.description}).permission(subCommand.permission.get()).handler(subCommand.executor::accept));
        }
        return builder.build();
    }

    @Override
    public void execute(CommandContext<UserAudience> context) {
        StringBuilder helpMessage = new StringBuilder("Available subcommands are:\n");
        for (SubCommand subCommand : SubCommand.VALUES) {
            if (!((UserAudience)context.getSender()).hasPermission(subCommand.permission.get())) continue;
            helpMessage.append('\n').append('\u00a7').append('b').append(subCommand.name().toLowerCase(Locale.ROOT)).append('\u00a7').append("f - ").append('\u00a7').append('7').append(subCommand.description);
        }
        ((UserAudience)context.getSender()).sendMessage(helpMessage.toString());
    }

    static enum SubCommand {
        FIREWALL("Check if your outgoing firewall allows Floodgate to work properly", Permission.COMMAND_MAIN_FIREWALL, FirewallCheckSubcommand::executeFirewall);

        static final SubCommand[] VALUES;
        final String description;
        final Permission permission;
        final Consumer<CommandContext<UserAudience>> executor;

        private SubCommand(String description, Permission permission, Consumer<CommandContext<UserAudience>> executor) {
            this.description = description;
            this.permission = permission;
            this.executor = executor;
        }

        static {
            VALUES = SubCommand.values();
        }
    }
}

