/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.command.main;

import cloud.commandframework.context.CommandContext;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.Pair;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.util.HttpUtils;
import org.geysermc.floodgate.util.Utils;

final class FirewallCheckSubcommand {
    private FirewallCheckSubcommand() {
    }

    static void executeFirewall(CommandContext<UserAudience> context) {
        UserAudience sender = (UserAudience)context.getSender();
        FirewallCheckSubcommand.executeChecks(FirewallCheckSubcommand.globalApiCheck(sender)).whenComplete((response, $) -> sender.sendMessage(String.format("\u00a7eThe checks have finished. %s/%s were successful", response.left(), (Integer)response.left() + (Integer)response.right())));
    }

    private static BooleanSupplier globalApiCheck(UserAudience sender) {
        return FirewallCheckSubcommand.executeFirewallText(sender, "global api", () -> {
            HttpUtils.HttpResponse<JsonElement> response = HttpUtils.get("https://api.geysermc.org/health", JsonElement.class);
            if (!response.isCodeOk()) {
                throw new IllegalStateException(String.format("Didn't receive an 'ok' http code. Got: %s, response: %s", response.getHttpCode(), response.getResponse()));
            }
        });
    }

    private static BooleanSupplier executeFirewallText(UserAudience sender, String name, Runnable runnable) {
        return () -> {
            sender.sendMessage("\u00a7eTesting " + name + "...");
            try {
                runnable.run();
                sender.sendMessage("\u00a7aWas able to connect to " + name + "!");
                return true;
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cFailed to connect:");
                sender.sendMessage(Utils.getStackTrace(e));
                return false;
            }
        };
    }

    private static CompletableFuture<Pair<Integer, Integer>> executeChecks(BooleanSupplier ... checks) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicInteger okCount = new AtomicInteger();
            AtomicInteger failCount = new AtomicInteger();
            for (BooleanSupplier check : checks) {
                if (check.getAsBoolean()) {
                    okCount.getAndIncrement();
                    continue;
                }
                failCount.getAndIncrement();
            }
            return Pair.of((Object)okCount.get(), (Object)failCount.get());
        });
    }
}

