/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.impl.FormImpl;
import org.geysermc.cumulus.form.util.FormCodec;
import org.geysermc.cumulus.form.util.FormType;
import org.geysermc.cumulus.response.FormResponse;
import org.geysermc.cumulus.response.result.FormResponseResult;

public abstract class FormDefinition<F extends Form, I extends FormImpl<R>, R extends FormResponse> {
    private final FormCodec<F, R> codec;
    private final FormType formType;
    private final Class<F> formClass;
    private final Class<I> formImplClass;

    protected FormDefinition(@NonNull FormCodec<F, R> codec, @NonNull FormType formType, @NonNull Class<F> formClass, @NonNull Class<I> formImplClass) {
        this.codec = Objects.requireNonNull(codec);
        this.formType = Objects.requireNonNull(formType);
        this.formClass = Objects.requireNonNull(formClass);
        this.formImplClass = Objects.requireNonNull(formImplClass);
    }

    public final @NonNull FormCodec<F, R> codec() {
        return this.codec;
    }

    public void handleFormResponse(F form, @Nullable String responseData) throws Exception {
        if (!this.callRawResponseConsumer(form, responseData)) {
            FormResponseResult<R> result = this.codec().deserializeFormResponse(form, responseData);
            this.callResponseHandler(form, result);
        }
    }

    protected boolean callRawResponseConsumer(F form, @Nullable String responseData) throws Exception {
        return ((FormImpl)form).callRawResponseConsumer(responseData);
    }

    protected void callResponseHandler(F form, FormResponseResult<R> result) throws Exception {
        ((FormImpl)form).callResultHandler(result);
    }

    public final @NonNull FormType formType() {
        return this.formType;
    }

    public final @NonNull Class<F> formClass() {
        return this.formClass;
    }

    public final @NonNull Class<I> formImplClass() {
        return this.formImplClass;
    }
}

