/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.updater.change;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.configutils.updater.change.Version;
import org.geysermc.configutils.updater.change.VersionBuilder;

public final class Changes {
    private final List<Version> changes;
    private List<Version> selected;

    private Changes(List<Version> changes) {
        this.changes = changes;
        changes.sort(Comparator.comparingInt(Version::versionNumber));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VersionBuilder versionBuilder() {
        return new VersionBuilder();
    }

    public boolean select(int currentVersion, int newVersion) {
        boolean wasSelected = this.selected != null;
        this.selected = this.allVersionsBetween(currentVersion, newVersion);
        return wasSelected;
    }

    public String oldKeyName(String newKeyName) {
        if (this.selected == null) {
            throw new IllegalStateException("Select a version range first");
        }
        String oldKeyName = newKeyName;
        for (int i = this.selected.size() - 1; i >= 0; --i) {
            oldKeyName = this.selected.get(i).oldKeyName(oldKeyName);
        }
        return oldKeyName;
    }

    public Object newValue(String key, Object currentValue) {
        if (this.selected == null) {
            throw new IllegalStateException("Select a version range first");
        }
        Object newValue = currentValue;
        for (Version version : this.selected) {
            newValue = version.newValue(key, newValue);
        }
        return newValue;
    }

    public @NonNull List<Version> allVersionsBetween(int currentVersion, int newVersion) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Version version : this.changes) {
            if (version.versionNumber() <= currentVersion) continue;
            if (version.versionNumber() > newVersion) break;
            versions.add(version);
        }
        return versions;
    }

    public static final class Builder {
        private final List<Version> changes = new ArrayList<Version>();

        private Builder() {
        }

        public @NonNull Builder version(int version, @NonNull VersionBuilder builder) {
            this.changes.add(Objects.requireNonNull(builder).build(version));
            return this;
        }

        public @NonNull Changes build() {
            return new Changes(this.changes);
        }
    }
}

