/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.parser.template.action;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ActionResult {
    private static final ActionResult OK = new ActionResult(null, null);
    private final Throwable error;
    private final List<String> linesToAdd;

    private ActionResult(Throwable error, List<String> linesToAdd) {
        this.error = error;
        this.linesToAdd = linesToAdd;
    }

    public static @NonNull ActionResult ok() {
        return OK;
    }

    public static @NonNull ActionResult failed(@NonNull Throwable error) {
        return new ActionResult(Objects.requireNonNull(error), null);
    }

    public static @NonNull ActionResult failed(@NonNull String errorMessage) {
        return ActionResult.failed(new IllegalStateException(Objects.requireNonNull(errorMessage)));
    }

    public static @NonNull ActionResult addLines(String ... lines) {
        return new ActionResult(null, Arrays.asList(lines));
    }

    public static @NonNull ActionResult addLines(@NonNull List<String> lines) {
        return new ActionResult(null, lines);
    }

    public @Nullable Throwable error() {
        return this.error;
    }

    public @Nullable List<String> linesToAdd() {
        return this.linesToAdd;
    }

    public boolean succeeded() {
        return this.error == null;
    }

    public boolean hasLinesToAdd() {
        return this.linesToAdd != null;
    }
}

