/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.scoreboard;

import com.github.steveice10.mc.protocol.data.game.scoreboard.NameTagVisibility;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamAction;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamColor;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard.ClientboundSetPlayerTeamPacket;
import java.util.Arrays;
import java.util.Set;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;

@Translator(packet=ClientboundSetPlayerTeamPacket.class)
public class JavaSetPlayerTeamTranslator
extends PacketTranslator<ClientboundSetPlayerTeamPacket> {
    private final GeyserLogger logger = GeyserImpl.getInstance().getLogger();

    @Override
    public void translate(GeyserSession session, ClientboundSetPlayerTeamPacket packet) {
        if (this.logger.isDebug()) {
            this.logger.debug("Team packet " + packet.getTeamName() + " " + packet.getAction() + " " + Arrays.toString(packet.getPlayers()));
        }
        if ((packet.getAction() == TeamAction.ADD_PLAYER || packet.getAction() == TeamAction.REMOVE_PLAYER) && packet.getPlayers().length == 0) {
            return;
        }
        int pps = session.getWorldCache().increaseAndGetScoreboardPacketsPerSecond();
        Scoreboard scoreboard = session.getWorldCache().getScoreboard();
        Team team = scoreboard.getTeam(packet.getTeamName());
        switch (packet.getAction()) {
            case CREATE: {
                team = scoreboard.registerNewTeam(packet.getTeamName(), packet.getPlayers()).setName(MessageTranslator.convertMessage(packet.getDisplayName())).setColor(packet.getColor()).setNameTagVisibility(packet.getNameTagVisibility()).setPrefix(MessageTranslator.convertMessage(packet.getPrefix(), session.locale())).setSuffix(MessageTranslator.convertMessage(packet.getSuffix(), session.locale()));
                if (packet.getPlayers().length == 0 || (team.getNameTagVisibility() == NameTagVisibility.ALWAYS || team.isVisibleFor(session.getPlayerEntity().getUsername())) && team.getColor() == TeamColor.RESET && team.getCurrentData().getPrefix().isEmpty() && team.getCurrentData().getSuffix().isEmpty()) break;
                scoreboard.updateEntityNames(team, true);
                break;
            }
            case UPDATE: {
                if (team == null) {
                    if (this.logger.isDebug()) {
                        this.logger.debug("Error while translating Team Packet " + packet.getAction() + "! Scoreboard Team " + packet.getTeamName() + " is not registered.");
                    }
                    return;
                }
                TeamColor oldColor = team.getColor();
                NameTagVisibility oldVisibility = team.getNameTagVisibility();
                String oldPrefix = team.getCurrentData().getPrefix();
                String oldSuffix = team.getCurrentData().getSuffix();
                team.setName(MessageTranslator.convertMessage(packet.getDisplayName())).setColor(packet.getColor()).setNameTagVisibility(packet.getNameTagVisibility()).setPrefix(MessageTranslator.convertMessage(packet.getPrefix(), session.locale())).setSuffix(MessageTranslator.convertMessage(packet.getSuffix(), session.locale())).setUpdateType(UpdateType.UPDATE);
                if (oldVisibility == team.getNameTagVisibility() && oldColor == team.getColor() && oldPrefix.equals(team.getCurrentData().getPrefix()) && oldSuffix.equals(team.getCurrentData().getSuffix())) break;
                scoreboard.updateEntityNames(team, false);
                break;
            }
            case ADD_PLAYER: {
                if (team == null) {
                    if (this.logger.isDebug()) {
                        this.logger.debug("Error while translating Team Packet " + packet.getAction() + "! Scoreboard Team " + packet.getTeamName() + " is not registered.");
                    }
                    return;
                }
                Set<String> added = team.addEntities(packet.getPlayers());
                scoreboard.updateEntityNames(team, added, true);
                break;
            }
            case REMOVE_PLAYER: {
                if (team == null) {
                    if (this.logger.isDebug()) {
                        this.logger.debug("Error while translating Team Packet " + packet.getAction() + "! Scoreboard Team " + packet.getTeamName() + " is not registered.");
                    }
                    return;
                }
                Set<String> removed = team.removeEntities(packet.getPlayers());
                scoreboard.updateEntityNames(null, removed, true);
                break;
            }
            case REMOVE: {
                scoreboard.removeTeam(packet.getTeamName());
            }
        }
        if (pps < ScoreboardUpdater.FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) {
            scoreboard.onUpdate();
        }
    }
}

