/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundForgetLevelChunkPacket;
import java.util.ArrayList;
import java.util.Iterator;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;

@Translator(packet=ClientboundForgetLevelChunkPacket.class)
public class JavaForgetLevelChunkTranslator
extends PacketTranslator<ClientboundForgetLevelChunkPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundForgetLevelChunkPacket packet) {
        session.getChunkCache().removeChunk(packet.getX(), packet.getZ());
        ArrayList<Vector3i> removedSkulls = new ArrayList<Vector3i>();
        for (Vector3i position : session.getSkullCache().getSkulls().keySet()) {
            if (position.getX() >> 4 != packet.getX() || position.getZ() >> 4 != packet.getZ()) continue;
            removedSkulls.add(position);
        }
        removedSkulls.forEach(session.getSkullCache()::removeSkull);
        if (!session.getGeyser().getWorldManager().shouldExpectLecternHandled(session)) {
            Iterator<Vector3i> iterator = session.getLecternCache().iterator();
            while (iterator.hasNext()) {
                Vector3i position;
                position = iterator.next();
                if (position.getX() >> 4 != packet.getX() || position.getZ() >> 4 != packet.getZ()) continue;
                iterator.remove();
            }
        }
        ChunkUtils.sendEmptyChunk(session, packet.getX(), packet.getZ(), false);
    }
}

