/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.inventory.VillagerTrade;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory.ClientboundMerchantOffersPacket;
import java.util.ArrayList;
import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.UpdateTradePacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.MerchantContainer;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.MathUtils;

@Translator(packet=ClientboundMerchantOffersPacket.class)
public class JavaMerchantOffersTranslator
extends PacketTranslator<ClientboundMerchantOffersPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundMerchantOffersPacket packet) {
        MerchantContainer merchantInventory;
        Inventory openInventory;
        block5: {
            block4: {
                openInventory = session.getOpenInventory();
                if (!(openInventory instanceof MerchantContainer)) break block4;
                merchantInventory = (MerchantContainer)openInventory;
                if (openInventory.getJavaId() == packet.getContainerId()) break block5;
            }
            return;
        }
        if (!openInventory.isPending()) {
            JavaMerchantOffersTranslator.openMerchant(session, packet, merchantInventory);
            return;
        }
        merchantInventory.setPendingOffersPacket(packet);
    }

    public static void openMerchant(GeyserSession session, ClientboundMerchantOffersPacket packet, MerchantContainer merchantInventory) {
        merchantInventory.setVillagerTrades(packet.getTrades());
        merchantInventory.setTradeExperience(packet.getExperience());
        Entity villager = merchantInventory.getVillager();
        if (packet.isRegularVillager()) {
            villager.getDirtyMetadata().put(EntityDataTypes.TRADE_TIER, packet.getVillagerLevel() - 1);
            villager.getDirtyMetadata().put(EntityDataTypes.MAX_TRADE_TIER, 4);
        } else {
            villager.getDirtyMetadata().put(EntityDataTypes.TRADE_TIER, 0);
            villager.getDirtyMetadata().put(EntityDataTypes.MAX_TRADE_TIER, 0);
        }
        villager.getDirtyMetadata().put(EntityDataTypes.TRADE_EXPERIENCE, packet.getExperience());
        villager.updateBedrockMetadata();
        UpdateTradePacket updateTradePacket = new UpdateTradePacket();
        updateTradePacket.setTradeTier(packet.getVillagerLevel() - 1);
        updateTradePacket.setContainerId((short)packet.getContainerId());
        updateTradePacket.setContainerType(ContainerType.TRADE);
        updateTradePacket.setDisplayName(session.getOpenInventory().getTitle());
        updateTradePacket.setSize(0);
        updateTradePacket.setNewTradingUi(true);
        updateTradePacket.setUsingEconomyTrade(true);
        updateTradePacket.setPlayerUniqueEntityId(session.getPlayerEntity().getGeyserId());
        updateTradePacket.setTraderUniqueEntityId(villager.getGeyserId());
        NbtMapBuilder builder = NbtMap.builder();
        boolean addExtraTrade = packet.isRegularVillager() && packet.getVillagerLevel() < 5;
        ArrayList<NbtMap> tags = new ArrayList<NbtMap>(addExtraTrade ? packet.getTrades().length + 1 : packet.getTrades().length);
        for (int i = 0; i < packet.getTrades().length; ++i) {
            VillagerTrade trade = packet.getTrades()[i];
            NbtMapBuilder recipe = NbtMap.builder();
            recipe.putInt("netId", i + 1);
            recipe.putInt("maxUses", trade.isTradeDisabled() ? 0 : trade.getMaxUses());
            recipe.putInt("traderExp", trade.getXp());
            recipe.putFloat("priceMultiplierA", trade.getPriceMultiplier());
            recipe.putFloat("priceMultiplierB", 0.0f);
            recipe.put("sell", (Object)JavaMerchantOffersTranslator.getItemTag(session, trade.getOutput()));
            recipe.putInt("buyCountA", trade.getFirstInput() != null ? Math.max(trade.getFirstInput().getAmount(), 0) : 0);
            recipe.putInt("buyCountB", trade.getSecondInput() != null ? Math.max(trade.getSecondInput().getAmount(), 0) : 0);
            recipe.putInt("demand", trade.getDemand());
            recipe.putInt("tier", packet.getVillagerLevel() > 0 ? packet.getVillagerLevel() - 1 : 0);
            recipe.put("buyA", (Object)JavaMerchantOffersTranslator.getItemTag(session, trade.getFirstInput(), trade.getSpecialPrice(), trade.getDemand(), trade.getPriceMultiplier()));
            recipe.put("buyB", (Object)JavaMerchantOffersTranslator.getItemTag(session, trade.getSecondInput()));
            recipe.putInt("uses", trade.getNumUses());
            recipe.putByte("rewardExp", (byte)1);
            tags.add(recipe.build());
        }
        if (addExtraTrade) {
            tags.add(NbtMap.builder().putInt("maxUses", 0).putInt("traderExp", 0).putFloat("priceMultiplierA", 0.0f).putFloat("priceMultiplierB", 0.0f).putInt("buyCountB", 0).putInt("buyCountA", 0).putInt("demand", 0).putInt("tier", 5).putInt("uses", 0).putByte("rewardExp", (byte)0).build());
        }
        builder.putList("Recipes", NbtType.COMPOUND, tags);
        ArrayList<NbtMap> expTags = new ArrayList<NbtMap>(5);
        expTags.add(NbtMap.builder().putInt("0", 0).build());
        expTags.add(NbtMap.builder().putInt("1", 10).build());
        expTags.add(NbtMap.builder().putInt("2", 70).build());
        expTags.add(NbtMap.builder().putInt("3", 150).build());
        expTags.add(NbtMap.builder().putInt("4", 250).build());
        builder.putList("TierExpRequirements", NbtType.COMPOUND, expTags);
        updateTradePacket.setOffers(builder.build());
        session.sendUpstreamPacket(updateTradePacket);
    }

    private static NbtMap getItemTag(GeyserSession session, ItemStack stack) {
        if (InventoryUtils.isEmpty(stack)) {
            return NbtMap.EMPTY;
        }
        return JavaMerchantOffersTranslator.getItemTag(session, stack, session.getItemMappings().getMapping(stack), stack.getAmount());
    }

    private static NbtMap getItemTag(GeyserSession session, ItemStack stack, int specialPrice, int demand, float priceMultiplier) {
        if (InventoryUtils.isEmpty(stack)) {
            return NbtMap.EMPTY;
        }
        ItemMapping mapping = session.getItemMappings().getMapping(stack);
        int count = stack.getAmount() + (int)Math.max(Math.floor((float)(stack.getAmount() * demand) * priceMultiplier), 0.0) + specialPrice;
        count = MathUtils.constrain(count, 1, ((Item)((List)Registries.JAVA_ITEMS.get()).get(stack.getId())).maxStackSize());
        return JavaMerchantOffersTranslator.getItemTag(session, stack, mapping, count);
    }

    private static NbtMap getItemTag(GeyserSession session, ItemStack stack, ItemMapping mapping, int count) {
        ItemData itemData = ItemTranslator.translateToBedrock(session, stack);
        String customIdentifier = (String)session.getItemMappings().getCustomIdMappings().get(itemData.getDefinition().getRuntimeId());
        NbtMapBuilder builder = NbtMap.builder();
        builder.putByte("Count", (byte)count);
        builder.putShort("Damage", (short)itemData.getDamage());
        builder.putString("Name", customIdentifier != null ? customIdentifier : mapping.getBedrockIdentifier());
        if (itemData.getTag() != null) {
            NbtMap tag = itemData.getTag().toBuilder().build();
            builder.put("tag", (Object)tag);
        }
        return builder.build();
    }
}

