/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerSpawnInfo;
import com.github.steveice10.mc.protocol.packet.common.serverbound.ServerboundCustomPayloadPacket;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundLoginPacket;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.packet.GameRulesChangedPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannels;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.erosion.GeyserboundHandshakePacketHandler;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.EntityUtils;

@Translator(packet=ClientboundLoginPacket.class)
public class JavaLoginTranslator
extends PacketTranslator<ClientboundLoginPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLoginPacket packet) {
        boolean needsSpawnPacket;
        SessionPlayerEntity entity = session.getPlayerEntity();
        entity.setEntityId(packet.getEntityId());
        if (session.getErosionHandler().isActive()) {
            session.getErosionHandler().close();
            session.setErosionHandler(new GeyserboundHandshakePacketHandler(session));
        }
        PlayerSpawnInfo spawnInfo = packet.getCommonPlayerSpawnInfo();
        if (session.isSpawned()) {
            String fakeDim = DimensionUtils.getTemporaryDimension(session.getDimension(), spawnInfo.getDimension());
            DimensionUtils.switchDimension(session, fakeDim);
            session.getWorldCache().removeScoreboard();
            session.getEntityCache().removeAllBossBars();
            entity.getAttributes().clear();
            entity.resetMetadata();
            if (session.isRaining()) {
                LevelEventPacket stopRainPacket = new LevelEventPacket();
                stopRainPacket.setType(LevelEvent.STOP_RAINING);
                stopRainPacket.setData(0);
                stopRainPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(stopRainPacket);
                session.setRaining(false);
            }
            if (session.isThunder()) {
                LevelEventPacket stopThunderPacket = new LevelEventPacket();
                stopThunderPacket.setType(LevelEvent.STOP_THUNDERSTORM);
                stopThunderPacket.setData(0);
                stopThunderPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(stopThunderPacket);
                session.setThunder(false);
            }
        }
        session.setWorldName(spawnInfo.getWorldName());
        session.setLevels(packet.getWorldNames());
        session.setGameMode(spawnInfo.getGameMode());
        String newDimension = spawnInfo.getDimension();
        boolean bl = needsSpawnPacket = !session.isSentSpawnPacket();
        if (needsSpawnPacket) {
            session.setDimension(newDimension);
            DimensionUtils.setBedrockDimension(session, newDimension);
            session.connect();
            session.getUpstream().sendPostStartGamePackets();
        } else {
            SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
            playerGameTypePacket.setGamemode(EntityUtils.toBedrockGamemode(spawnInfo.getGameMode()).ordinal());
            session.sendUpstreamPacket(playerGameTypePacket);
        }
        entity.setLastDeathPosition(spawnInfo.getLastDeathPos());
        entity.updateBedrockMetadata();
        GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("doimmediaterespawn", !packet.isEnableRespawnScreen()));
        session.sendUpstreamPacket(gamerulePacket);
        session.setReducedDebugInfo(packet.isReducedDebugInfo());
        session.setServerRenderDistance(packet.getViewDistance());
        session.sendJavaClientSettings();
        if (session.remoteServer().authType() == AuthType.FLOODGATE) {
            session.sendDownstreamPacket(new ServerboundCustomPayloadPacket("minecraft:register", PluginMessageChannels.getFloodgateRegisterData()));
        }
        if (!newDimension.equals(session.getDimension())) {
            DimensionUtils.switchDimension(session, newDimension);
        } else if (DimensionUtils.isCustomBedrockNetherId() && newDimension.equalsIgnoreCase("minecraft:the_nether")) {
            session.camera().sendFog("minecraft:fog_hell");
        }
        ChunkUtils.loadDimension(session);
    }
}

